/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit.scoping
import java.util.ArrayList
import java.util.Collections
import java.util.List
import org.eclipse.emf.common.util.EList
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.resource.IEObjectDescription
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.FilteringScope
import org.eclipse.xtext.scoping.impl.ImportNormalizer
import org.eclipse.xtext.scoping.impl.SimpleScope
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.ExpressionsPackage
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypesPackage
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.scoping.STextScopeProvider
import com.yakindu.sct.model.stext.stext.StextPackage
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.google.common.base.Predicate
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.SCTUnitPackage
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
/** 
 * @author andreas muelder - Initial contribution and API
 */
class SCTUnitScopeProvider extends STextScopeProvider {
	
	static class VariablePredicate implements Predicate<IEObjectDescription>{
		override boolean apply(IEObjectDescription input) {
			if (input.getEClass().equals(StextPackage.Literals.VARIABLE_DEFINITION)) {
				return !input.getEObjectURI().lastSegment().endsWith(".sctunit") 
			}
			return true 
		}// FIXME!!!!
		
	}
	protected static final VariablePredicate VARIABLEPREDICATE=new VariablePredicate()
	override protected List<ImportNormalizer> getActiveStateNormalizer(EObject context) {
		return Collections.singletonList(new ImportNormalizer(QualifiedName.create(getStatechart(context).getName()),true,false)) 
	}
	override IScope scope_TypeSpecifier_type(EObject context, EReference reference) {
		return new FilteringScope(getDelegate().getScope(context, reference),[IEObjectDescription input|if (input.getEClass().equals(TypesPackage.Literals.ANNOTATION_TYPE)) {
			return false 
		}return input.getEClass().getEPackage().equals(TypesPackage.eINSTANCE) || input.getEClass().equals(SCTUnitPackage.Literals.SCT_UNIT_CLASS) ]) 
	}
	def IScope scope_ElementReferenceExpression_reference(MockReturnStatement context, EReference reference) {
		var IScope scope=new ElementReferenceScope(new FilteringScope(super.scope_ElementReferenceExpression_reference(context, reference),VARIABLEPREDICATE),context) 
		var Operation referencedOperation=getOperationOfMocking(context.getReference()) 
		if (referencedOperation !== null) {
			scope=addOperationParamsToMockingScope(context, scope) 
		}
		return scope 
	}
	def protected Operation getOperationOfMocking(Expression reference) {
		if (reference instanceof ElementReferenceExpression) {
			var ElementReferenceExpression referenceExpression=(reference as ElementReferenceExpression) 
			if (referenceExpression.getReference() instanceof Operation) {
				return (referenceExpression.getReference() as Operation) 
			}
		} else if (reference instanceof FeatureCall) {
			var FeatureCall featureCall=(reference as FeatureCall) 
			if (featureCall.getFeature() instanceof Operation) {
				return (featureCall.getFeature() as Operation) 
			}
		}
		return null 
	}
	override IScope scope_ElementReferenceExpression_reference(EObject context, EReference reference) {
		var IScope scope=new ElementReferenceScope(new FilteringScope(super.scope_ElementReferenceExpression_reference(context, reference),VARIABLEPREDICATE),context) 
		var MockingStatement mockStmt=EcoreUtil2.getContainerOfType(context, MockingStatement) 
		if (mockStmt !== null && mockStmt.getReference() !== null) {
			scope=addOperationParamsToMockingScope(mockStmt, scope) 
		}
		return scope 
	}
	def IScope scope_ElementReferenceExpression_reference(LogicalRelationExpression context, EReference reference) {
		var IScope scope=new ElementReferenceScope(new FilteringScope(super.scope_ElementReferenceExpression_reference(context, reference),[IEObjectDescription input|if (input.getEClass().equals(TypesPackage.Literals.PRIMITIVE_TYPE)) {
			return false 
		}return true ]),context) 
		var MockingStatement mockStmt=EcoreUtil2.getContainerOfType(context, MockingStatement) 
		if (mockStmt !== null && mockStmt.getReference() !== null) {
			scope=addOperationParamsToMockingScope(mockStmt, scope) 
		}
		return scope 
	}
	def protected EObject getOperation(Expression expr) {
		if (expr instanceof ElementReferenceExpression) {
			return (expr.eGet(ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, false) as EObject) 
		} else if (expr instanceof FeatureCall) {
			return (expr.eGet(ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, false) as EObject) 
		} else {
			return null 
		}
	}
	override protected Statechart getStatechart(EObject context) {
		var SCTUnitClass clazz=EcoreUtil2.getContainerOfType(context, SCTUnitClass) 
		if (clazz !== null) {
			return clazz.getStatechart() 
		} else {
			return super.getStatechart(context) 
		}
	}
	def protected IScope addOperationParamsToMockingScope(MockingStatement mockStmt, IScope scope_finalParam_) {
		var  scope=scope_finalParam_ 
		var EObject operation=getOperation(mockStmt.getReference()) 
		var SCTUnitOperation op=EcoreUtil2.getContainerOfType(mockStmt, SCTUnitOperation) 
		var SCTUnitClass clazz=getSCTUnitClass(mockStmt) 
		if (operation !== null && !operation.eIsProxy()) {
			var IScope sc=addVariablesToScope(op, scope) 
			if (mockStmt instanceof MockReturnStatement) {
				scope=new FilteringScope(sc,[IEObjectDescription input|return (!input.getEClass().equals(TypesPackage.Literals.OPERATION) && !input.getEClass().equals(StextPackage.Literals.OPERATION_DEFINITION)) ]) 
				scope=new SimpleScope(scope,Scopes.scopedElementsFor(getSCTUnitOperations(clazz))) 
			} else {
				scope=sc 
			}
		}
		return scope 
	}
	def protected IScope addVariablesToScope(SCTUnitOperation op, IScope scope_finalParam_) {
		var  scope=scope_finalParam_ 
		var SCTUnitClass clazz=EcoreUtil2.getContainerOfType(op, SCTUnitClass) 
		var List<VariableDefinition> variables=new ArrayList() 
		for (VariableDefinitionStatement variableDefinition : clazz.getVariableDefinitions()) {
			variables.add(variableDefinition.getDefinition()) 
		}
		scope=Scopes.scopeFor(variables, scope) 
		return Scopes.scopeFor(EcoreUtil2.getAllContentsOfType(op, VariableDefinition), scope) 
	}
	/** 
	 * Adds local Variables to the unnamed scope
	 */
	override protected IScope getUnnamedTopLevelScope(EObject context, EReference reference) {
		var SCTUnitOperation operation=EcoreUtil2.getContainerOfType(context, SCTUnitOperation) 
		if (operation === null) return getDelegate().getScope(context, reference) 
		var EList<TestStatement> statements=operation.getBody().getCode() 
		var List<VariableDefinition> localVariables=new ArrayList() 
		for (TestStatement testStatement : statements) {
			if (testStatement instanceof VariableDefinitionStatement) {
				var VariableDefinition definition=((testStatement as VariableDefinitionStatement)).getDefinition() 
				localVariables.add(definition) 
			}
		}
		var IScope localVarScope=Scopes.scopeFor(localVariables) 
		var SimpleScope toplevelScope=new SimpleScope(super.getUnnamedTopLevelScope(context, reference).getAllElements()) 
		return new SimpleScope(toplevelScope,localVarScope.getAllElements()) 
	}
	def protected SCTUnitClass getSCTUnitClass(EObject object) {
		return EcoreUtil2.getContainerOfType(object, SCTUnitClass) 
	}
	def protected List<SCTUnitOperation> getSCTUnitOperations(SCTUnitClass clazz) {
		return EcoreUtil2.getAllContentsOfType(clazz, SCTUnitOperation) 
	}
}