/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.simulation.core.interpreter;

import com.google.inject.Inject;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sct.simulation.core.sexec.container.SexecExecutionContextInitializer;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class DefaultSCTUnitExecutionContextInitializer implements ISCTUnitExecutionContextInitializer {
  @Inject
  @Extension
  protected ITypeSystemInferrer _iTypeSystemInferrer;

  @Inject
  @Extension
  protected IQualifiedNameProvider _iQualifiedNameProvider;

  @Inject
  @Extension
  protected SexecExecutionContextInitializer _sexecExecutionContextInitializer;

  @Inject
  private IExpressionInterpreter statementInterpreter;

  protected final SRuntimeFactory factory = SRuntimeFactory.eINSTANCE;

  @Override
  public void initialize(final ExecutionContext context, final SCTUnitClass unitClass) {
    CompositeSlot _createCompositeSlot = this.factory.createCompositeSlot();
    final Procedure1<CompositeSlot> _function = (CompositeSlot it) -> {
      it.setName(unitClass.getName());
      it.setFqName(this._iQualifiedNameProvider.getFullyQualifiedName(unitClass).toString());
    };
    CompositeSlot slot = ObjectExtensions.<CompositeSlot>operator_doubleArrow(_createCompositeSlot, _function);
    this.initializeGlobalVariables(context, unitClass.getVariableDefinitions(), slot);
    List<ExecutionSlot> _slots = context.getSlots();
    _slots.add(slot);
  }

  @Override
  public void dispose(final ExecutionContext context, final SCTUnitOperation unitOperation) {
    final SCTUnitClass unitClass = EcoreUtil2.<SCTUnitClass>getContainerOfType(unitOperation, SCTUnitClass.class);
    ExecutionSlot _find = this.find(context.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitClass));
    final CompositeSlot classSlot = ((CompositeSlot) _find);
    final ExecutionSlot operationSlot = this.find(classSlot.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitOperation));
    EObject _eContainer = operationSlot.eContainer();
    final List<ExecutionSlot> containerSlots = ((CompositeSlot) _eContainer).getSlots();
    containerSlots.remove(operationSlot);
  }

  protected boolean dispose(final CompositeSlot context, final SCTUnitOperation unitOperation) {
    boolean _xblockexpression = false;
    {
      final ExecutionSlot operationSlot = this.find(context.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitOperation));
      EObject _eContainer = operationSlot.eContainer();
      final List<ExecutionSlot> containerSlots = ((CompositeSlot) _eContainer).getSlots();
      _xblockexpression = containerSlots.remove(operationSlot);
    }
    return _xblockexpression;
  }

  @Override
  public void initialize(final ExecutionContext context, final SCTUnitOperation unitOperation, final List<Expression> args) {
    final SCTUnitClass unitClass = EcoreUtil2.<SCTUnitClass>getContainerOfType(unitOperation, SCTUnitClass.class);
    CompositeSlot operationSlot = this.initializeOperationSlot(unitOperation, args, context);
    ExecutionSlot _find = this.find(context.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitClass));
    boolean _tripleEquals = (_find == null);
    if (_tripleEquals) {
      this.initialize(context, unitClass);
    }
    ExecutionSlot _find_1 = this.find(context.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitClass));
    List<ExecutionSlot> _slots = ((CompositeSlot) _find_1).getSlots();
    _slots.add(operationSlot);
  }

  @Override
  public void initialize(final ExecutionContext context, final SCTUnitOperation unitOperation, final List<Expression> args, final SCTUnitOperation owner) {
    CompositeSlot operationSlot = this.initializeOperationSlot(unitOperation, args, context);
    ExecutionSlot _find = this.find(context.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(owner));
    final CompositeSlot ownerSlot = ((CompositeSlot) _find);
    ExecutionSlot _find_1 = this.find(ownerSlot.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitOperation));
    boolean _tripleNotEquals = (_find_1 != null);
    if (_tripleNotEquals) {
      this.dispose(ownerSlot, unitOperation);
    }
    ExecutionSlot _find_2 = this.find(context.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(owner));
    List<ExecutionSlot> _slots = ((CompositeSlot) _find_2).getSlots();
    _slots.add(operationSlot);
  }

  protected CompositeSlot initializeOperationSlot(final SCTUnitOperation unitOperation, final List<Expression> args, final ExecutionContext context) {
    CompositeSlot _createCompositeSlot = this.factory.createCompositeSlot();
    final Procedure1<CompositeSlot> _function = (CompositeSlot it) -> {
      it.setName(unitOperation.getName());
      it.setType(this._iTypeSystemInferrer.infer(unitOperation).getType());
      it.setFqName(this._iQualifiedNameProvider.getFullyQualifiedName(unitOperation).toString());
    };
    CompositeSlot operationSlot = ObjectExtensions.<CompositeSlot>operator_doubleArrow(_createCompositeSlot, _function);
    int _size = args.size();
    int _size_1 = unitOperation.getParameters().size();
    boolean _equals = (_size == _size_1);
    if (_equals) {
      this.initializeOperationParams(context, unitOperation.getParameters(), operationSlot, args);
    }
    return operationSlot;
  }

  @Override
  public void initialize(final ExecutionContext context, final VariableDefinition definition, final SCTUnitOperation unitOperation) {
    final SCTUnitClass unitClass = EcoreUtil2.<SCTUnitClass>getContainerOfType(unitOperation, SCTUnitClass.class);
    ExecutionSlot _find = this.find(context.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitClass));
    final CompositeSlot classSlot = ((CompositeSlot) _find);
    ExecutionSlot _find_1 = this.find(classSlot.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(unitOperation));
    final CompositeSlot operationSlot = ((CompositeSlot) _find_1);
    ExecutionSlot variableSlot = this.find(operationSlot.getSlots(), this._iQualifiedNameProvider.getFullyQualifiedName(definition));
    if ((variableSlot == null)) {
      variableSlot = this._sexecExecutionContextInitializer.createExecutionSlotFor(definition);
      List<ExecutionSlot> _slots = operationSlot.getSlots();
      _slots.add(variableSlot);
    }
    Expression _initialValue = definition.getInitialValue();
    boolean _tripleNotEquals = (_initialValue != null);
    if (_tripleNotEquals) {
      variableSlot.setValue(this.statementInterpreter.evaluate(definition.getInitialValue(), context));
    }
  }

  protected void initializeOperationParams(final ExecutionContext context, final List<Parameter> params, final CompositeSlot operationSlot, final List<Expression> args) {
    for (int i = 0; (i < params.size()); i++) {
      {
        final int index = i;
        List<ExecutionSlot> _slots = operationSlot.getSlots();
        ExecutionVariable _createExecutionVariable = this.factory.createExecutionVariable();
        final Procedure1<ExecutionVariable> _function = (ExecutionVariable it) -> {
          it.setName(params.get(index).getName());
          it.setType(this._iTypeSystemInferrer.infer(params.get(index)).getType());
          it.setValue(this.statementInterpreter.evaluate(args.get(index), context));
          it.setFqName(this._iQualifiedNameProvider.getFullyQualifiedName(params.get(index)).toString());
        };
        ExecutionVariable _doubleArrow = ObjectExtensions.<ExecutionVariable>operator_doubleArrow(_createExecutionVariable, _function);
        _slots.add(_doubleArrow);
      }
    }
  }

  protected void initializeGlobalVariables(final ExecutionContext context, final List<VariableDefinitionStatement> variables, final CompositeSlot classSlot) {
    for (int i = 0; (i < variables.size()); i++) {
      {
        final int index = i;
        List<ExecutionSlot> _slots = classSlot.getSlots();
        ExecutionVariable _createExecutionVariable = this.factory.createExecutionVariable();
        final Procedure1<ExecutionVariable> _function = (ExecutionVariable it) -> {
          it.setName(variables.get(index).getDefinition().getName());
          it.setType(this._iTypeSystemInferrer.infer(variables.get(index).getDefinition()).getType());
          it.setValue(this.statementInterpreter.evaluate(variables.get(index).getDefinition().getInitialValue(), context));
          it.setFqName(this._iQualifiedNameProvider.getFullyQualifiedName(variables.get(index).getDefinition()).toString());
        };
        ExecutionVariable _doubleArrow = ObjectExtensions.<ExecutionVariable>operator_doubleArrow(_createExecutionVariable, _function);
        _slots.add(_doubleArrow);
      }
    }
  }

  protected ExecutionSlot find(final List<ExecutionSlot> slots, final QualifiedName fullyQualifiedName) {
    final Function1<ExecutionSlot, Boolean> _function = (ExecutionSlot it) -> {
      String _fqName = it.getFqName();
      String _string = fullyQualifiedName.toString();
      return Boolean.valueOf(Objects.equals(_fqName, _string));
    };
    final ExecutionSlot found = IterableExtensions.<ExecutionSlot>findFirst(slots, _function);
    if ((found == null)) {
      for (final ExecutionSlot slot : slots) {
        if ((slot instanceof CompositeSlot)) {
          final ExecutionSlot resultSlot = this.find(((CompositeSlot)slot).getSlots(), fullyQualifiedName);
          if ((resultSlot != null)) {
            return resultSlot;
          }
        }
      }
    }
    return found;
  }
}
