/**
 * Copyright (c) 2016-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 	Axel Terfloth - itemis AG
 */
package com.yakindu.sctunit.simulation.core.interpreter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.BitwiseAndExpression;
import com.yakindu.base.expressions.expressions.BitwiseOrExpression;
import com.yakindu.base.expressions.expressions.BitwiseXorExpression;
import com.yakindu.base.expressions.expressions.ConditionalExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.LogicalAndExpression;
import com.yakindu.base.expressions.expressions.LogicalNotExpression;
import com.yakindu.base.expressions.expressions.LogicalOrExpression;
import com.yakindu.base.expressions.expressions.LogicalRelationExpression;
import com.yakindu.base.expressions.expressions.NumericalAddSubtractExpression;
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression;
import com.yakindu.base.expressions.expressions.NumericalUnaryExpression;
import com.yakindu.base.expressions.expressions.ParenthesizedExpression;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.ShiftExpression;
import com.yakindu.base.expressions.expressions.TypeCastExpression;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.base.types.Expression;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.transformation.IModelSequencer;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression;
import com.yakindu.sct.simulation.core.sexec.interpreter.MultiStatechartInjector;
import com.yakindu.sct.simulation.core.sexec.interpreter.StatechartRuntimeExtension;
import com.yakindu.sctunit.sCTUnit.EnterExpression;
import com.yakindu.sctunit.sCTUnit.ExitExpression;
import com.yakindu.sctunit.sCTUnit.ProceedExpression;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.StatechartActiveExpression;
import com.yakindu.sctunit.sCTUnit.StatechartFinalExpression;
import com.yakindu.sctunit.sCTUnit.TriggerWithoutEventExpression;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * @author andreas muelder - Initial contribution and API
 * @author axel terfloth - Integration of new interpreter
 */
@Singleton
@SuppressWarnings("all")
public class ExecutionFlowSCTUnitTestCaseInterpreter extends BaseSCTUnitTestCaseInterpreter {
  @Inject
  @Extension
  private StatechartAnnotations _statechartAnnotations;

  @Inject
  protected IModelSequencer sequencer;

  @Inject
  protected IInterpreter interpreter;

  @Inject
  @Extension
  protected StatechartRuntimeExtension _statechartRuntimeExtension;

  @Inject
  @Extension
  protected IExecutionSlotResolver _iExecutionSlotResolver;

  @Inject
  @Extension
  protected MultiStatechartInjector injector;

  protected ExecutionFlow flow;

  @Override
  public void init(final SCTUnitClass unitClass) {
    this.flow = this.sequencer.transform(unitClass.getStatechart());
    this.context = this._statechartRuntimeExtension.newInstance(this.flow);
    this._statechartRuntimeExtension.init(this.context);
    this.sctUnitContextInitializer.initialize(this.context, unitClass);
    boolean _isCycleBased = this._statechartAnnotations.isCycleBased(unitClass.getStatechart());
    if (_isCycleBased) {
      this.cyclePeriod = this._statechartAnnotations.getCyclePeriod(unitClass.getStatechart());
      final Runnable _function = () -> {
        this._statechartRuntimeExtension.runCycle(this.context);
      };
      ITimeTaskScheduler.TimeTask cycleTask = new ITimeTaskScheduler.TimeTask(ITimeTaskScheduler.TimeTask.CYCLE_TASK_NAME, _function, ITimeTaskScheduler.TimeTask.Priority.LOW);
      this.schedulingService.scheduleTimeTask(cycleTask, true, this.cyclePeriod);
    }
    this.injector.inject(this.context);
  }

  @Override
  public void tearDown() {
    super.tearDown();
    this.interpreter.reset();
  }

  protected Object _execute(final StatechartFinalExpression expression) {
    return Boolean.valueOf(this._statechartRuntimeExtension.isFinal(this.context));
  }

  @Override
  protected Object _execute(final EventValueReferenceExpression expression) {
    return this.interpreter.evaluate(this.context, expression);
  }

  protected Object _execute(final StatechartActiveExpression expression) {
    return Boolean.valueOf(this._statechartRuntimeExtension.isActive(this.context));
  }

  @Override
  protected Object _execute(final ElementReferenceExpression expression) {
    SCTUnitOperation _expressionSCTUnitOperation = this.getExpressionSCTUnitOperation(expression);
    boolean _tripleNotEquals = (_expressionSCTUnitOperation != null);
    if (_tripleNotEquals) {
      final SCTUnitOperation owner = EcoreUtil2.<SCTUnitOperation>getContainerOfType(expression, SCTUnitOperation.class);
      return this.executeStatement(this.getExpressionSCTUnitOperation(expression), expression.getExpressions(), this.testCase, owner);
    } else {
      boolean _requiresStatechartScopeExecution = this.requiresStatechartScopeExecution(expression);
      if (_requiresStatechartScopeExecution) {
        return this.interpreter.evaluate(this.context, expression);
      }
    }
    return this.executeElementReferenceExpression(expression);
  }

  @Override
  protected Object _execute(final EventRaisingExpression eventRaising) {
    final Object event = this.interpreter.evaluate(this.context, eventRaising.getEvent());
    Expression _value = eventRaising.getValue();
    Object _execute = null;
    if (_value!=null) {
      _execute=this.execute(_value);
    }
    final Object value = _execute;
    this.interpreter.raiseEvent(event, value);
    return null;
  }

  @Override
  protected Object _execute(final FeatureCall call) {
    SCTUnitOperation _expressionSCTUnitOperation = this.getExpressionSCTUnitOperation(call);
    boolean _tripleNotEquals = (_expressionSCTUnitOperation != null);
    if (_tripleNotEquals) {
      final SCTUnitOperation owner = EcoreUtil2.<SCTUnitOperation>getContainerOfType(call, SCTUnitOperation.class);
      return this.executeStatement(this.getExpressionSCTUnitOperation(call), call.getExpressions(), this.testCase, owner);
    } else {
      boolean _requiresStatechartScopeExecution = this.requiresStatechartScopeExecution(call);
      if (_requiresStatechartScopeExecution) {
        return this.interpreter.evaluate(this.context, call);
      } else {
        return this.executeFeatureCall(call);
      }
    }
  }

  @Override
  protected Optional<ExecutionSlot> resolveSlot(final ExecutionContext context, final Expression expression) {
    Optional<ExecutionSlot> _xifexpression = null;
    boolean _requiresStatechartScopeExecution = this.requiresStatechartScopeExecution(expression);
    if (_requiresStatechartScopeExecution) {
      final Object result = this.interpreter.evaluate(context, expression);
      Optional<ExecutionSlot> _xifexpression_1 = null;
      if (((result != null) && (result instanceof ExecutionSlot))) {
        _xifexpression_1 = Optional.<ExecutionSlot>of(
          ((ExecutionSlot) result));
      } else {
        _xifexpression_1 = Optional.<ExecutionSlot>empty();
      }
      return _xifexpression_1;
    } else {
      _xifexpression = super.resolveSlot(context, expression);
    }
    return _xifexpression;
  }

  @Override
  protected Object setValue(final ExecutionSlot slot, final Object value, final EObject target) {
    Object _xifexpression = null;
    boolean _requiresStatechartScopeExecution = this.requiresStatechartScopeExecution(target);
    if (_requiresStatechartScopeExecution) {
      this.interpreter.setValue(slot, value);
      return value;
    } else {
      _xifexpression = super.setValue(slot, value, target);
    }
    return _xifexpression;
  }

  protected boolean _requiresStatechartScopeExecution(final Object it) {
    return false;
  }

  protected boolean _requiresStatechartScopeExecution(final EObject it) {
    return ((EcoreUtil2.<Statechart>getContainerOfType(it, Statechart.class) != null) || (EcoreUtil2.<SCTUnitClass>getContainerOfType(it, SCTUnitClass.class) == null));
  }

  protected boolean _requiresStatechartScopeExecution(final FeatureCall it) {
    return this.requiresStatechartScopeExecution(it.getOwner());
  }

  protected boolean _requiresStatechartScopeExecution(final ElementReferenceExpression it) {
    return this.requiresStatechartScopeExecution(it.getReference());
  }

  protected Object _execute(final EnterExpression stm) {
    Object _xblockexpression = null;
    {
      this._statechartRuntimeExtension.enter(this.context);
      _xblockexpression = null;
    }
    return _xblockexpression;
  }

  protected Object _execute(final TriggerWithoutEventExpression stm) {
    Object _xblockexpression = null;
    {
      this._statechartRuntimeExtension.triggerWithoutEvent(this.context);
      _xblockexpression = null;
    }
    return _xblockexpression;
  }

  protected Object _execute(final ExitExpression stm) {
    Object _xblockexpression = null;
    {
      this._statechartRuntimeExtension.exit(this.context);
      _xblockexpression = null;
    }
    return _xblockexpression;
  }

  @Override
  @XbaseGenerated
  public Object execute(final Expression expression) {
    if (expression instanceof BitwiseAndExpression) {
      return _execute((BitwiseAndExpression)expression);
    } else if (expression instanceof BitwiseOrExpression) {
      return _execute((BitwiseOrExpression)expression);
    } else if (expression instanceof BitwiseXorExpression) {
      return _execute((BitwiseXorExpression)expression);
    } else if (expression instanceof ElementReferenceExpression) {
      return _execute((ElementReferenceExpression)expression);
    } else if (expression instanceof FeatureCall) {
      return _execute((FeatureCall)expression);
    } else if (expression instanceof LogicalAndExpression) {
      return _execute((LogicalAndExpression)expression);
    } else if (expression instanceof LogicalNotExpression) {
      return _execute((LogicalNotExpression)expression);
    } else if (expression instanceof LogicalOrExpression) {
      return _execute((LogicalOrExpression)expression);
    } else if (expression instanceof LogicalRelationExpression) {
      return _execute((LogicalRelationExpression)expression);
    } else if (expression instanceof NumericalAddSubtractExpression) {
      return _execute((NumericalAddSubtractExpression)expression);
    } else if (expression instanceof NumericalMultiplyDivideExpression) {
      return _execute((NumericalMultiplyDivideExpression)expression);
    } else if (expression instanceof NumericalUnaryExpression) {
      return _execute((NumericalUnaryExpression)expression);
    } else if (expression instanceof PostFixUnaryExpression) {
      return _execute((PostFixUnaryExpression)expression);
    } else if (expression instanceof ShiftExpression) {
      return _execute((ShiftExpression)expression);
    } else if (expression instanceof AssignmentExpression) {
      return _execute((AssignmentExpression)expression);
    } else if (expression instanceof ConditionalExpression) {
      return _execute((ConditionalExpression)expression);
    } else if (expression instanceof EventRaisingExpression) {
      return _execute((EventRaisingExpression)expression);
    } else if (expression instanceof EventValueReferenceExpression) {
      return _execute((EventValueReferenceExpression)expression);
    } else if (expression instanceof ParenthesizedExpression) {
      return _execute((ParenthesizedExpression)expression);
    } else if (expression instanceof PrimitiveValueExpression) {
      return _execute((PrimitiveValueExpression)expression);
    } else if (expression instanceof TypeCastExpression) {
      return _execute((TypeCastExpression)expression);
    } else if (expression instanceof ActiveStateReferenceExpression) {
      return _execute((ActiveStateReferenceExpression)expression);
    } else if (expression instanceof EnterExpression) {
      return _execute((EnterExpression)expression);
    } else if (expression instanceof ExitExpression) {
      return _execute((ExitExpression)expression);
    } else if (expression instanceof ProceedExpression) {
      return _execute((ProceedExpression)expression);
    } else if (expression instanceof StatechartActiveExpression) {
      return _execute((StatechartActiveExpression)expression);
    } else if (expression instanceof StatechartFinalExpression) {
      return _execute((StatechartFinalExpression)expression);
    } else if (expression instanceof TriggerWithoutEventExpression) {
      return _execute((TriggerWithoutEventExpression)expression);
    } else if (expression != null) {
      return _execute(expression);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(expression).toString());
    }
  }

  @XbaseGenerated
  protected boolean requiresStatechartScopeExecution(final Object it) {
    if (it instanceof ElementReferenceExpression) {
      return _requiresStatechartScopeExecution((ElementReferenceExpression)it);
    } else if (it instanceof FeatureCall) {
      return _requiresStatechartScopeExecution((FeatureCall)it);
    } else if (it instanceof EObject) {
      return _requiresStatechartScopeExecution((EObject)it);
    } else if (it != null) {
      return _requiresStatechartScopeExecution(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
