/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.python

import com.google.inject.Inject
import com.yakindu.base.types.TypesUtil
import com.yakindu.sct.generator.python.PythonExpressionsGenerator
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.generator.python.naming.PythonNamingService
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.AbstractSubchartInitializer

class PythonSubchartInitializer extends AbstractSubchartInitializer {

	@Inject protected extension Naming
	@Inject protected extension PythonExpressionsGenerator
	@Inject protected extension SExecExtensions
	@Inject protected extension PythonNamingService
	@Inject protected extension TypesUtil

	protected def getter(VariableDefinition it) {
		'''«context»«identifier»'''
	}

	protected def setter(VariableDefinition it) {
		'''«context»«identifier»'''
	}
	
	def String getContext(VariableDefinition it) {
		if (isInNamedInterface) {
			return '''«interfaceScope.interfaceVariableName».'''
		}
		return ""
	}
	
	override buildImports(Statechart subchart) {
		imports.put(subchart, subchart.statemachineClassName)
	}
	
	override buildInitSequence(Statechart subchart, VariableDefinition element) {
		val getElementChain = variableStack.listIterator.join("", ".", "", [getter])
		val getParentChain = variableStack.listIterator.take(variableStack.size -1).join("", ".", ".", [getter])
		
		initSequence += '''
			self.statemachine.«getParentChain»«variableStack.lastOrNull.setter» = «subchart.statemachineName»()
			«IF subchart.isTimed»
				self.statemachine.«getElementChain».timer_service = self.timer_service
			«ENDIF»
		'''
	}
	
	override buildTeardownSequence(Statechart subchart, VariableDefinition element) {}

}
