/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sctunit.generator.base.extensions.BaseMockingExtensions
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions
import com.yakindu.sctunit.inferrer.TypesProvider
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import java.util.List
import java.util.Set
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

/**
 * 
 * @author Jonathan Thoene - Initial contribution and API
 * 
 */
class CMockingExtensions extends BaseMockingExtensions {
		
	@Inject protected extension MockClassExtension
	@Inject protected extension SCTUnitCNaming
	@Inject protected extension Naming
	@Inject extension ICodegenTypeSystemAccess
	@Inject protected TypesProvider provider
	@Inject protected extension BaseStatementExtensions
	@Inject protected extension EventQueue
	@Inject(optional=true) ExecutionFlow flow
	
	def getTypeSystem (EObject context) {
		return provider.getTypeSystem(context)
	}
	
	def initializeOperationMocks(SCTUnitOperation it) {
		val operations = getAllOperations(allMockStatementsInOperation)
		
		'''
			«FOR op : operations»
				«op.initializeOperationMock(SCTUnitClass.isOperationForStatement(op, typeof(MockReturnStatement)))»
			«ENDFOR»
		'''
	}
	
	def resetOperationMocks(SCTUnitOperation it){
		val operations = getAllOperations(allMockStatementsInOperation)
		
		'''
			«FOR op : operations.toList.reverse»
				«op.resetOperationMock()»
			«ENDFOR»
			«FOR op : operations.toList.reverse»
				«op.freeOperationMock»
			«ENDFOR»
		'''
	}

	def generateOperationMockClasses(SCTUnitClass it) {
		'''
			«FOR op : getAllOperations(allMockStatementsInClass)»
				«op.generateMockClass(getAllMockStatementsForOperation(op), it)»
			«ENDFOR»
		'''
	}
	
	def generateVerifyCalled(VerifyCalledStatement it) {
		if(!negated) {
			generatePositiveVerify
		} else {
			generateNegativeVerify
		}
	}

	def protected generatePositiveVerify(VerifyCalledStatement it) {
		val params = reference.expressions
		'''
			«IF times !== null»
				EXPECT_TRUE(«operationMockObjectName(operationOfMockStatement)»->calledAtLeast(«times.value»«FOR param : params», «param.code»«ENDFOR»));
			«ELSE»
				EXPECT_TRUE(«operationMockObjectName(operationOfMockStatement)»->calledAtLeastOnce(«FOR param : params SEPARATOR ', '»«param.code»«ENDFOR»));
			«ENDIF»
		'''
	}
	
	def protected generateNegativeVerify(VerifyCalledStatement it) {
		val params = reference.expressions
		'''
			EXPECT_FALSE(«operationMockObjectName(operationOfMockStatement)»->calledAtLeastOnce(«FOR param : params SEPARATOR ', '»«param.code»«ENDFOR»));
		'''
	}

	def generateMock(MockReturnStatement it) {
		// skip mocks on void functions
		if (value === null) {
			return ""
		}
		'''
			«IF it.reference.expressions.nullOrEmpty»«operationOfMockStatement.operationMockObjectName()»->setDefaultBehavior(&«operationMockClassName(operationOfMockStatement)»::«functionNameForReturnStatement»);
			«ELSE»«operationOfMockStatement.operationMockObjectName()»->«operationOfMockStatement.setReturnBehavior»(«FOR param : it.reference.expressions SEPARATOR ', '»«param.code»«ENDFOR»,&«operationMockClassName(operationOfMockStatement)»::«functionNameForReturnStatement»);«ENDIF»
		'''
	}

	def initializeOperationMock(Operation it, boolean initialize) {
		'''
			«operationMockObjectName» = new «operationMockClassName»();
			«IF initialize»
				«operationMockObjectName»->initializeBehavior();
			«ENDIF»
		'''
	}
	
	def freeOperationMock(Operation it) {
		'''
			delete «operationMockObjectName»;
		'''
	}
	
	
	def protected resetOperationMock(Operation it) {
		'''«operationMockObjectName»->reset();'''
	}
	
	def generateRequiredOperations(SCTUnitClass it) {
		val statechartOperations = statechart.scopes.map[s|s.declarations].flatten.filter(Operation).toList
		val mockedOperations = getAllOperations(allMockStatementsInClass).filter[op|!statechartOperations.contains(op)]
		'''
			«FOR op : statechartOperations»
				«generateStatechartOperationSignature(op)»
					SC_UNUSED(«statechartNaming»);
					«IF !isOperationForStatement(op, typeof(VerifyCalledStatement)) && !isOperationForStatement(op, typeof(MockReturnStatement))»
						«FOR param : op.parameters»
							SC_UNUSED(«param.name»);
						«ENDFOR»
					«ENDIF»
					«IF isOperationForStatement(op, typeof(VerifyCalledStatement))»
						«op.generateVerifyStatement»
					«ENDIF»
					«IF isOperationForStatement(op, typeof(MockReturnStatement))»
						«op.generateMockReturnStatement»
					«ELSE»
						«defaultReturn(op.getType)»
					«ENDIF»
				}
			«ENDFOR»
			«FOR op : mockedOperations»
				«op.generateOperationSignature»
					SC_UNUSED(«statechartNaming»);
					«IF isOperationForStatement(op, typeof(VerifyCalledStatement))»
						«op.generateVerifyStatement»
					«ENDIF»
					«IF isOperationForStatement(op, typeof(MockReturnStatement))»
						«op.generateMockReturnStatement»
					«ELSE»
						«defaultReturn(op.getType)»
					«ENDIF»
				}
			«ENDFOR»
		'''
	}

	protected def CharSequence generateStatechartOperationSignature(SCTUnitClass it,Operation op) {
		'''
			«op.typeSpecifier.targetLanguageName» «op.asFunction»(«IF ! flow.requiresIncomingEventQueue»const «ENDIF»«(op.getContainerOfType(typeof(Statechart))).type»* «statechartNaming»«FOR param : op.parameters», const «param.getType.targetLanguageName» «param.name»«ENDFOR») {
		'''
	}
	
	protected def CharSequence generateOperationSignature(Operation it) {
		'''
			«it.typeSpecifier.targetLanguageName» «name»(«FOR param : parameters SEPARATOR ', '»«param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR») {
		'''
	}

	def protected generateVerifyStatement(Operation it) {
		'''
			«operationMockObjectName»->«name»(«FOR param : parameters SEPARATOR ', '»«param.name»«ENDFOR»);
		'''
	}

	def protected generateMockReturnStatement(Operation it) {
		'''
			return («operationMockObjectName»->*(«operationMockObjectName»->getBehavior(«FOR param : parameters SEPARATOR ', '»«param.name»«ENDFOR»)))();
		'''
	}

	def protected indexOfStatement(MockReturnStatement it) {
		val op = operationOfMockStatement
		val tp = EcoreUtil2.getContainerOfType(it, typeof(SCTUnitClass))
		tp.features.map[tc|(tc as SCTUnitOperation).body.code].flatten.filter(MockReturnStatement).filter[stmt|stmt.operationOfMockStatement == op].toSet.
			toList.indexOf(it)
	}

	def protected getAllMockStatementsForOperation(SCTUnitClass it, Operation op) {
		SCTUnitOperations.map[tc|tc.body.code].flatten.filter(MockingStatement).filter[ms|ms.operationOfMockStatement == op].toSet
	}

	def isOperationForStatement(SCTUnitClass it, Operation op, Class<? extends MockingStatement> statement) {
		EcoreUtil2.getAllContentsOfType(it, typeof(MockingStatement)).filter(statement).map[vs|vs.operationOfMockStatement].toSet.contains(op)
	}

	def protected isTypeString(Parameter it) {
		it.typeSystem.isSame(getType?.originType, it.typeSystem.getType(ITypeSystem.STRING))
	}
	
	def dispatch getExpressions(Expression it){
		
	}
	
	def Set<Operation> getAllOperations(List<MockingStatement> allMockReturns) {
		return allMockReturns.map[operationOfMockStatement].toSet
	}
	
	def dispatch getExpressions(ElementReferenceExpression it) {
		return expressions
	}
	
	def dispatch getExpressions(FeatureCall it) {
		return expressions
	}
	
	def List<MockingStatement> getAllMockStatementsInClass(SCTUnitClass it) {
		SCTUnitOperations.map[allMockStatementsInOperation].flatten.toList
	}
	
	def List<MockingStatement> getAllMockStatementsInOperation(SCTUnitOperation it) {
		EcoreUtil2.getAllContentsOfType(it, MockingStatement)
	}
}
