/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.sctunit.generator.c.features.BaseGenmodel
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries

class Genmodel extends BaseGenmodel {

	@Inject extension BaseNamingExtensions
	
	@Inject protected SCTUnitCNaming naming

	@Inject protected GeneratorEntry entry
	
	@Inject extension CSCTUnitGenmodelEntries

	override generateGenmodel(SCTUnitClass it, IFileSystemAccess fsa) {

		testClassName = naming.testClassName(it)
		generatorType = "c"
		
		var content = generateGenModel
		fsa.generateFile(sgenFileName, content)
	}
	
	def getSgenFileName(SCTUnitClass it) {
		if (!entry.identifierModuleName.isEmpty) {
			return naming.sgen(entry.identifierModuleName)
		}
		return naming.sgen(statechart.className)
	}

}
