/**
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.generator.c.CSCTUnitFileSystemAccessFactory
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.sCTUnit.TestPackage
import org.eclipse.emf.common.util.URI
import org.eclipse.xtext.generator.IFileSystemAccess

class JUnitTest {

	@Inject protected SCTUnitCNaming naming
	@Inject extension BaseNamingExtensions
	@Inject extension BaseNavigationExtensions
	@Inject extension CSCTUnitGenmodelEntries

	@Inject
	protected GeneratorEntry entry

	@Inject
	protected ICoreLibraryHelper helper

	def generateJUnitTest(TestPackage it, IFileSystemAccess fsa, String targetProjectName) {

		var targetProjectString = helper.getTargetProjectValue(entry).stringValue

		var testFileName = '''«naming.testClassName(SCTUnitElement).java»'''.toString

		var content = SCTUnitElement.generateTest(targetProjectString)
		fsa.generateFile(testFileName, CSCTUnitFileSystemAccessFactory.C_JUNIT_OUTPUT, content)
	}

	def dispatch generateTest(SCTUnitClass it, String targetProjectString) {
		'''
			«entry.licenseText»
			package «targetProjectString»«IF !namespace(testPackage).toString.nullOrEmpty».«ENDIF»«it.namespace»;
			
			import org.junit.Before;
			import org.junit.runner.RunWith;
			import com.yakindu.sct.generator.c.gtest.GTest;
			import com.yakindu.sct.generator.c.gtest.GTestRunner;
			import com.yakindu.sct.generator.c.gtest.GTestHelper;
			
			@GTest(
				statechartBundle = "«statechart.eResource.URI.segment(1)»",
				sourceFile = "«entry.targetFolderString»/«naming.cc(naming.testClassName(it))»",
				program = "«entry.targetFolderString»/«IF !entry.identifierModuleName.isEmpty»«entry.identifierModuleName»«ELSE»«statechart.className»«ENDIF»",
				model = "«statechart.eResource.URI.modelFromUri»",
				additionalFilesToCopy = {
					"«IF entry.libraryTargetFeature === null»«entry.targetFolderString»«ELSE»«entry.libraryTargetFolderString»«ENDIF»/sc_unit_timer_service.c",
					"«IF entry.libraryTargetFeature === null»«entry.targetFolderString»«ELSE»«entry.libraryTargetFolderString»«ENDIF»/sc_unit_timer_service.h"
				},
				additionalFilesToCompile = {
					"«IF !entry.identifierModuleName.isEmpty»«entry.identifierModuleName»«ELSE»«statechart.className»«ENDIF».c",
					"sc_unit_timer_service.c"
				}
			)
			@RunWith(GTestRunner.class)
			public class «testClassName» {
			
				protected final GTestHelper helper = new GTestHelper(this);
			
				@Before
				public void setUp() {
					helper.generate();
					helper.compile();
				}
			}
		'''
	}

	/**
	 * Derives and returns the path implied by the namespace as string. 
	 * The hierarchical namespace will be mapped to a path by substituting the namespace
	 * separators by path separators with an additional trailing path separator if the namespace exists. 
	 */
	def String asPath(String namespace) {
		if (namespace !== null && ! namespace.empty) {
			return namespace.replace('.', '/') + '/'
		}
		return ''
	}

	def dispatch generateTest(SCTUnitSuite it, String targetProjectString) {
		'''
			«entry.licenseText»
			package «targetProjectString»«IF !namespace(testPackage).toString.nullOrEmpty».«ENDIF»«it.namespace»;
			import org.junit.runner.RunWith;
			import org.junit.runners.Suite;
			import org.junit.runners.Suite.SuiteClasses;
			
			@RunWith(Suite.class)
			@SuiteClasses({
				«FOR group : SCTUnitClasses SEPARATOR ','»
					«group.testClassName».class
				«ENDFOR»
			})
			public class «className» {
			}
		'''
	}
	
	def protected isTimed(SCTUnitClass it) {
		statechart.eAllContents.findFirst[it instanceof TimeEventSpec] !== null
	}
	
	def protected getModelFromUri(URI uri){
		var model = uri.segment(2)
		for(var i=3; i<uri.segmentsList.size; i++){
			model = model + "/" + uri.segment(i)
		}
		return model
	}
}
