/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.c.features

import com.google.inject.Inject
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.typesystem.CTypeSystem
import com.yakindu.sct.model.sgen.FeatureConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.base.SCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.TestPackage

import static com.yakindu.sctunit.generator.base.features.BaseFeaturesLibraryConstants.*
import static com.yakindu.sctunit.generator.c.features.CSCTUnitFeatureConstants.*

class CSCTUnitGenmodelEntries extends SCTUnitGenmodelEntries {

	@Inject protected extension ITypeSystem

	def getOutletFeature(GeneratorEntry it) {
		getFeatureConfiguration(OUTLET_FEATURE)
	}

	def getTargetProject(GeneratorEntry it) {
		outletFeature?.getParameterValue(OUTLET_FEATURE_TARGET_PROJECT).stringValue
	}

	def boolean isIdentifierFeature(GeneratorEntry it) {
		var FeatureConfiguration idFeature = getFeatureConfiguration(FEATURE_IDENTIFIER_SETTINGS)
		return if(idFeature === null) false else true
	}

	def isJUnitWrapper(GeneratorEntry it) {
		var FeatureConfiguration jUnitWrapUp = getFeatureConfiguration(CSCTUnitFeatureConstants.FEATURE_JUNIT_WRAP)
		if (jUnitWrapUp !== null) {
			return jUnitWrapUp.getParameterValue(CSCTUnitFeatureConstants.PARAMETER_JUNIT_WRAP).booleanValue
		}
		return false;
	}

	def boolean isSGen(GeneratorEntry it) {
		var FeatureConfiguration sgen = getFeatureConfiguration(CSCTUnitFeatureConstants.FEATURE_SGEN_MODEL)
		if (sgen !== null) {
			return sgen.getParameterValue(CSCTUnitFeatureConstants.PARAMETER_GENERATE_SGEN).booleanValue
		}
		return false
	}

	def getTestPackage(GeneratorEntry entry) {
		return entry.elementRef.eContainer as TestPackage
	}

	def getJavaPackageForProjectName(String targetProject) {
		return targetProject.replaceAll("\\.", "/");
	}

	def getIdentifierLength(GeneratorEntry it) {

		var FeatureConfiguration idFeature = getFeatureConfiguration(FEATURE_IDENTIFIER_SETTINGS)
		var Integer maxLenght = 31

		if (idFeature !== null && idFeature.getParameterValue(PARAMETER_MAX_IDENTIFIER_LENGTH) !== null)
			maxLenght = Integer.valueOf(idFeature.getParameterValue(PARAMETER_MAX_IDENTIFIER_LENGTH).stringValue)

		return maxLenght
	}

	def getIdentifierModuleName(GeneratorEntry it) {

		var FeatureConfiguration idFeature = getFeatureConfiguration(FEATURE_IDENTIFIER_SETTINGS)
		var String moduleName = ""

		if (idFeature !== null && idFeature.getParameterValue(PARAMETER_MODULE_NAME) !== null)
			moduleName = idFeature.getParameterValue(PARAMETER_MODULE_NAME).stringValue

		return moduleName
	}

	def getIdentifierStatemachinePrefix(GeneratorEntry it) {

		var FeatureConfiguration idFeature = getFeatureConfiguration(
			CSCTUnitFeatureConstants.FEATURE_IDENTIFIER_SETTINGS)
		var String prefix = ""

		if (idFeature !== null && idFeature.getParameterValue(PARAMETER_STATEMACHINE_PREFIX) !== null)
			prefix = idFeature.getParameterValue(PARAMETER_STATEMACHINE_PREFIX).stringValue

		return prefix
	}

	def getIdentifierSeparator(GeneratorEntry it) {

		var FeatureConfiguration idFeature = getFeatureConfiguration(FEATURE_IDENTIFIER_SETTINGS)
		var String separator = ""

		if (idFeature !== null && idFeature.getParameterValue(PARAMETER_SEPARATOR) !== null)
			separator = idFeature.getParameterValue(PARAMETER_SEPARATOR).stringValue

		return separator
	}
	
	def getTestFilenameExtension(GeneratorEntry it) {
		testFilenameExtensionParameter?.stringValue?:"cc"
	}
	
	def testFilenameExtensionParameter(GeneratorEntry it) {
		getFeatureConfiguration(FEATURE_IDENTIFIER_SETTINGS)?.getParameterValue(PARAMETER_TEST_FILENAME_EXTENSION)
	}

	def getSCTBaseFeature(GeneratorEntry it) {
		var FeatureConfiguration feature = getFeatureConfiguration(FUNCTION_INLINING_FEATURE)
		return feature;
	}

	def isInlineFeature(GeneratorEntry it) {
		var boolean isInlineFeature = false
		var FeatureConfiguration idFeature = getFeatureConfiguration(FUNCTION_INLINING_FEATURE)

		if (idFeature !== null)
			isInlineFeature = true

		return isInlineFeature
	}

	def getInlineReactions(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_REACTIONS)
	}

	def getInlineEntryActions(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_ENTRY_ACTIONS)
	}

	def getInlineEnterSequences(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_ENTER_SEQUENCES)
	}

	def getInlineExitActions(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_EXIT_ACTIONS)
	}

	def getInlineExitSequences(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_EXIT_SEQUENCES)
	}

	def getInlineChoices(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_CHOICES)
	}

	def getInlineEntries(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_ENTRIES)
	}

	def getInlineEnterRegion(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_ENTER_REGION)
	}

	def getInlineExitRegion(GeneratorEntry it) {
		getInlineFeatureValue(FUNCTION_INLINING_FEATURE_INLINE_EXIT_REGION)
	}
	
	def getTimerServiceTimeType(GeneratorEntry it) {
		val parameter = getFeatureConfiguration(GENERAL_FEATURE)?.getParameterValue(TIMER_SERVICE_TIME_TYPE)
		if (parameter !== null && !parameter.stringValue.nullOrEmpty) {
			getType(parameter.getStringValue)
		} else {
			getType(CTypeSystem.INTEGER)
		}
	}

	def protected getInlineFeatureValue(GeneratorEntry it, String value) {
		var FeatureConfiguration feature = getSCTBaseFeature
		var String reactions = "";
		if (feature !== null && feature.getParameterValue(value) !== null)
			reactions = feature.getParameterValue(value).stringValue
		return reactions;
	}
}
