/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.editpolicies;

import com.yakindu.base.gmf.runtime.editparts.LiveFeedbackResizableEditPolicy;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Straight;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;

public class BarResizeEditPolicy
extends LiveFeedbackResizableEditPolicy {
    private static final int thickness = 8;

    @Override
    protected ResizeTracker getResizeTracker(int direction) {
        return new ResizeTracker(this.getHost(), direction){

            protected void enforceConstraintsForResize(ChangeBoundsRequest request) {
                Rectangle locationAndSize = BarResizeEditPolicy.this.getOriginalBounds();
                Rectangle origRequestedBounds = request.getTransformedRectangle(locationAndSize);
                Rectangle modified = origRequestedBounds.getCopy();
                BarResizeEditPolicy.this.checkAndPrepareConstraint(request, modified);
                Dimension newDelta = new Dimension(modified.width - locationAndSize.width, modified.height - locationAndSize.height);
                request.setSizeDelta(newDelta);
                Point moveDelta = request.getMoveDelta();
                request.setMoveDelta(new Point(moveDelta.x - origRequestedBounds.x + modified.x, moveDelta.y - origRequestedBounds.y + modified.y));
            }
        };
    }

    private void checkAndPrepareConstraint(ChangeBoundsRequest request, Rectangle rect) {
        GraphicalEditPart editPart = null;
        for (Object ep : request.getEditParts()) {
            if (editPart != null || !(ep instanceof GraphicalEditPart)) continue;
            editPart = (GraphicalEditPart)ep;
            editPart.getFigure().translateToRelative((Translatable)rect);
        }
        int direction = request.getResizeDirection();
        boolean vertical = Math.abs(rect.height) > Math.abs(rect.width);
        Straight straight = null;
        switch (direction) {
            case 16: {
                straight = new Straight(new Vector((double)rect.x, (double)(rect.y + rect.height / 2)), new Vector((double)this.ifZero(rect.width, 1), 0.0));
                break;
            }
            case 8: {
                straight = new Straight(new Vector((double)(rect.x + rect.width), (double)(rect.y + rect.height / 2)), new Vector((double)(-this.ifZero(rect.width, 1)), 0.0));
                break;
            }
            case 4: {
                straight = new Straight(new Vector((double)(rect.x + rect.width / 2), (double)rect.y), new Vector(0.0, (double)this.ifZero(rect.height, 1)));
                break;
            }
            case 1: {
                straight = new Straight(new Vector((double)(rect.x + rect.width / 2), (double)(rect.y + rect.height)), new Vector(0.0, (double)(-this.ifZero(rect.height, 1))));
                break;
            }
            case 12: {
                straight = new Straight(new Vector((double)(rect.x + rect.width), (double)rect.y), new Vector((double)(-this.ifZero(rect.width, 1)), (double)this.ifZero(rect.height, 1)));
                break;
            }
            case 9: {
                straight = new Straight(new Vector((double)(rect.x + rect.width), (double)(rect.y + rect.height)), new Vector((double)(-this.ifZero(rect.width, 1)), (double)(-this.ifZero(rect.height, 1))));
                break;
            }
            case 17: {
                straight = new Straight(new Vector((double)rect.x, (double)(rect.y + rect.height)), new Vector((double)this.ifZero(rect.width, 1), (double)(-this.ifZero(rect.height, 1))));
                break;
            }
            default: {
                straight = new Straight(new Vector((double)rect.x, (double)rect.y), new Vector((double)this.ifZero(rect.width, 1), (double)this.ifZero(rect.height, 1)));
            }
        }
        if (straight != null) {
            Rectangle bar = null;
            bar = vertical ? (straight.direction.y == 0.0 ? new Rectangle((int)straight.position.x - this.ifWest(direction, 8), rect.y, 8, rect.height) : (straight.direction.y > 0.0 ? new Rectangle((int)straight.position.x - this.ifWest(direction, 8), (int)straight.position.y, 8, (int)straight.direction.y) : new Rectangle((int)straight.position.x - this.ifWest(direction, 8), (int)(straight.position.y + straight.direction.y), 8, (int)(-straight.direction.y)))) : (straight.direction.x == 0.0 ? new Rectangle(rect.x, (int)straight.position.y - this.ifNorth(direction, 8), rect.width, 8) : (straight.direction.x >= 0.0 ? new Rectangle((int)straight.position.x, (int)straight.position.y - this.ifNorth(direction, 8), (int)straight.direction.x, 8) : new Rectangle((int)(straight.position.x + straight.direction.x), (int)(straight.position.y - (double)this.ifNorth(direction, 8)), (int)(-straight.direction.x), 8)));
            rect.setBounds(bar);
        }
        if (editPart != null) {
            editPart.getFigure().translateToAbsolute((Translatable)rect);
        }
    }

    private int ifNorth(int direction, int value) {
        return (direction & 1) > 0 ? value : 0;
    }

    private int ifWest(int direction, int value) {
        return (direction & 8) > 0 ? value : 0;
    }

    private int ifZero(int value, int defaultValue) {
        return value == 0 ? defaultValue : value;
    }
}

