/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.highlighting;

import com.yakindu.base.gmf.runtime.highlighting.HighlightingParameters;
import com.yakindu.base.gmf.runtime.highlighting.IHighlightingSupport;
import com.yakindu.base.gmf.runtime.util.EditPartUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class HighlightingSupportAdapter
implements IHighlightingSupport {
    private final Map<IFigure, ColorMemento> figureStates = new HashMap<IFigure, ColorMemento>();
    private boolean locked = false;
    private Set<IFigure> flashingFigures = new HashSet<IFigure>();
    private final IDiagramWorkbenchPart diagramWorkbenchPart;
    private Map<EObject, IGraphicalEditPart> object2editPart = new HashMap<EObject, IGraphicalEditPart>();

    public HighlightingSupportAdapter(IDiagramWorkbenchPart diagramWorkbenchPart) {
        this.diagramWorkbenchPart = diagramWorkbenchPart;
    }

    private IGraphicalEditPart getEditPartForSemanticElement(EObject semanticElement) {
        IGraphicalEditPart result = this.object2editPart.get(semanticElement);
        if (result != null) {
            return result;
        }
        result = EditPartUtils.findEditPartForSemanticElement((EditPart)this.diagramWorkbenchPart.getDiagramGraphicalViewer().getRootEditPart(), semanticElement);
        this.object2editPart.put(semanticElement, result);
        return result;
    }

    private IFigure getTargetFigure(IGraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        if (figure instanceof BorderedNodeFigure) {
            figure = (IFigure)figure.getChildren().get(0);
        }
        if (figure instanceof DefaultSizeNodeFigure) {
            figure = (IFigure)figure.getChildren().get(0);
        }
        return figure;
    }

    @Override
    public synchronized void lockEditor() {
        if (this.locked) {
            throw new IllegalStateException("Editor already locked!");
        }
        this.lockEditorInternal();
    }

    private synchronized void lockEditorInternal() {
        this.setSanityCheckEnablementState(false);
        for (Object editPart : this.diagramWorkbenchPart.getDiagramGraphicalViewer().getEditPartRegistry().values()) {
            if (!(editPart instanceof IPrimaryEditPart)) continue;
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
            IFigure figure = this.getTargetFigure(graphicalEditPart);
            this.figureStates.put(figure, new ColorMemento(figure));
        }
        this.locked = true;
    }

    private void setSanityCheckEnablementState(boolean state) {
        try {
            Method enableMethod = DiagramDocumentEditor.class.getDeclaredMethod("enableSanityChecking", Boolean.TYPE);
            enableMethod.setAccessible(true);
            enableMethod.invoke((Object)this.diagramWorkbenchPart, state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void releaseEditor() {
        if (!this.locked) {
            throw new IllegalStateException("Editor not locked!");
        }
        this.releaseEditorInternal();
    }

    protected synchronized void releaseEditorInternal() {
        for (ColorMemento figureState : this.figureStates.values()) {
            figureState.restore();
        }
        this.flashingFigures.clear();
        this.figureStates.clear();
        this.diagramWorkbenchPart.getDiagramEditPart().enableEditMode();
        this.setSanityCheckEnablementState(true);
        this.object2editPart.clear();
        this.locked = false;
    }

    @Override
    public synchronized void releaseAndLockEditor() {
        if (!this.locked) {
            throw new IllegalStateException("Editor not locked!");
        }
        this.releaseEditorInternal();
        this.lockEditorInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void highlight(List<? extends EObject> semanticElements, HighlightingParameters parameters) {
        HighlightingSupportAdapter highlightingSupportAdapter = this;
        synchronized (highlightingSupportAdapter) {
            if (!this.locked) {
                return;
            }
            for (EObject eObject : semanticElements) {
                IGraphicalEditPart editPartForSemanticElement = this.getEditPartForSemanticElement(eObject);
                if (editPartForSemanticElement == null) continue;
                IFigure figure = this.getTargetFigure(editPartForSemanticElement);
                if (parameters != null) {
                    figure.setForegroundColor(parameters.foregroundFadingColor);
                    figure.setBackgroundColor(parameters.backgroundFadingColor);
                    figure.invalidate();
                    continue;
                }
                this.flashingFigures.clear();
                ColorMemento memento = this.figureStates.get(figure);
                if (memento == null) continue;
                memento.restore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flash(List<? extends EObject> semanticElements, HighlightingParameters parameters) {
        HighlightingSupportAdapter highlightingSupportAdapter = this;
        synchronized (highlightingSupportAdapter) {
            if (!this.locked) {
                return;
            }
            for (EObject eObject : semanticElements) {
                IGraphicalEditPart editPartForSemanticElement = this.getEditPartForSemanticElement(eObject);
                if (editPartForSemanticElement == null) continue;
                IFigure figure = this.getTargetFigure(editPartForSemanticElement);
                Fader fader = new Fader(figure, figure.getForegroundColor(), parameters.foregroundFadingColor, figure.getBackgroundColor(), parameters.backgroundFadingColor, parameters.highlightTime, true, parameters.flashcounter, true);
                Display.getCurrent().asyncExec((Runnable)fader);
            }
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void executeAsync(final List<IHighlightingSupport.Action> actions) {
        if (actions != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IHighlightingSupport.Action a : actions) {
                        a.execute(HighlightingSupportAdapter.this);
                    }
                }
            });
        }
    }

    private class ColorMemento {
        private final Color foregroundColor;
        private final Color backgroundColor;
        private final IFigure figure;

        protected ColorMemento(IFigure figure) {
            this.figure = figure;
            this.foregroundColor = figure.getForegroundColor();
            this.backgroundColor = figure.getBackgroundColor();
        }

        protected void restore() {
            this.figure.setForegroundColor(this.foregroundColor);
            this.figure.setBackgroundColor(this.backgroundColor);
        }
    }

    private class Fader
    implements Runnable {
        private final int fadingTime;
        private final Color sourceForegroundColor;
        private final Color targetForegroundColor;
        private final IFigure figure;
        private final boolean shouldFadeBack;
        private final boolean shouldRegister;
        private final Color sourceBackgroundColor;
        private final Color targetBackgroundColor;
        private final int flashCounter;

        private Fader(IFigure figure, Color sourceForegroundColor, Color targetForegroundColor, Color sourceBackgroundColor, Color targetBackgroundColor, int fadingTime, boolean shouldFadeBack, int flashCounter, boolean shouldRegister) {
            this.figure = figure;
            this.sourceForegroundColor = sourceForegroundColor;
            this.targetForegroundColor = targetForegroundColor;
            this.sourceBackgroundColor = sourceBackgroundColor;
            this.targetBackgroundColor = targetBackgroundColor;
            this.shouldFadeBack = shouldFadeBack;
            this.fadingTime = fadingTime;
            this.flashCounter = flashCounter;
            this.shouldRegister = shouldRegister;
        }

        @Override
        public void run() {
            if (this.shouldRegister) {
                if (HighlightingSupportAdapter.this.flashingFigures.contains(this.figure)) {
                    return;
                }
                HighlightingSupportAdapter.this.flashingFigures.add(this.figure);
            }
            if (HighlightingSupportAdapter.this.flashingFigures.contains(this.figure)) {
                this.figure.setForegroundColor(this.targetForegroundColor);
                this.figure.setBackgroundColor(this.targetBackgroundColor);
                this.figure.invalidate();
                if (this.shouldFadeBack) {
                    if (this.figure.getForegroundColor() == this.sourceForegroundColor && this.figure.getBackgroundColor() == this.sourceBackgroundColor) {
                        Fader fader = new Fader(this.figure, this.targetForegroundColor, this.sourceForegroundColor, this.targetBackgroundColor, this.sourceBackgroundColor, this.fadingTime, false, this.flashCounter - 1, false);
                        Display.getCurrent().timerExec(this.fadingTime, (Runnable)fader);
                    } else {
                        Fader fader = new Fader(this.figure, this.figure.getForegroundColor(), this.sourceForegroundColor, this.figure.getBackgroundColor(), this.sourceBackgroundColor, this.fadingTime, false, this.flashCounter - 1, false);
                        Display.getCurrent().timerExec(this.fadingTime, (Runnable)fader);
                    }
                } else if (this.flashCounter > 0) {
                    Display.getCurrent().timerExec(this.fadingTime, (Runnable)new Fader(this.figure, this.targetForegroundColor, this.sourceForegroundColor, this.targetBackgroundColor, this.sourceBackgroundColor, this.fadingTime, true, this.flashCounter, false));
                } else {
                    HighlightingSupportAdapter.this.flashingFigures.remove(this.figure);
                }
            }
        }
    }
}

