/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.treelayout;

import com.yakindu.base.gmf.runtime.treelayout.TreeLayoutConstraint;
import com.yakindu.base.gmf.runtime.treelayout.UIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;

public class TreeLayoutUtil {
    public static final String TREE_LAYOUT_ANNOTATION = "TreeLayoutAnnotation";
    public static final String TREE_NODE_POSITION = "TreeNodePosition";
    public static final String TREE_NODE_PARENT_URI = "TreeNodeParentURI";

    private TreeLayoutUtil() {
    }

    public static List<IGraphicalEditPart> getSiblings(IGraphicalEditPart child) {
        ArrayList<IGraphicalEditPart> treeChildren;
        IGraphicalEditPart parentEditPart;
        View parentView = TreeLayoutUtil.getTreeNodeParentView(child.getNotationView());
        if (parentView != null && (parentEditPart = (IGraphicalEditPart)child.findEditPart(child.getParent(), parentView.getElement())) != null && (treeChildren = TreeLayoutUtil.getOrderedTreeChildren(parentEditPart)).remove(child)) {
            return treeChildren;
        }
        return Collections.emptyList();
    }

    public static ArrayList<IGraphicalEditPart> getOrderedTreeChildren(IGraphicalEditPart parentTreeNodeEditPart) {
        ArrayList<IGraphicalEditPart> children = new ArrayList<IGraphicalEditPart>();
        DiagramEditPart diagramEditPart = UIUtils.getDiagramEditPart();
        if (diagramEditPart != null) {
            ConnectionLayer connectionLayer = (ConnectionLayer)diagramEditPart.getLayer((Object)"Connection Layer");
            for (Connection connection : TreeLayoutUtil.getTreeFigureIncomingConnections(connectionLayer, parentTreeNodeEditPart.getFigure())) {
                Object object = parentTreeNodeEditPart.getParent().getViewer().getVisualPartMap().get(connection.getSourceAnchor().getOwner());
                if (!(object instanceof IGraphicalEditPart)) continue;
                children.add((IGraphicalEditPart)object);
            }
        }
        IGraphicalEditPart[] orderedChildren = new IGraphicalEditPart[children.size()];
        ArrayList<IGraphicalEditPart> unorderedChildren = new ArrayList<IGraphicalEditPart>();
        for (IGraphicalEditPart editPart : children) {
            int treePosition = TreeLayoutUtil.getTreeNodePosition(editPart);
            if (treePosition == -1 || treePosition >= orderedChildren.length || orderedChildren[treePosition] != null) {
                unorderedChildren.add(editPart);
                continue;
            }
            orderedChildren[treePosition] = editPart;
        }
        Iterator iterator = unorderedChildren.iterator();
        while (iterator.hasNext()) {
            IGraphicalEditPart editPart;
            orderedChildren[TreeLayoutUtil.getNextEmptyIndex((IGraphicalEditPart[])orderedChildren)] = editPart = (IGraphicalEditPart)iterator.next();
        }
        return new ArrayList<IGraphicalEditPart>(Arrays.asList(orderedChildren));
    }

    public static int getNextEmptyIndex(IGraphicalEditPart[] list) {
        int index = 0;
        while (index < list.length) {
            if (list[index] == null) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int getConstrainedTreeNodePosition(IFigure figure) {
        Object constraint = figure.getParent().getLayoutManager().getConstraint(figure);
        if (constraint instanceof TreeLayoutConstraint) {
            return ((TreeLayoutConstraint)((Object)constraint)).getTreeInnerRankIndex();
        }
        return -1;
    }

    public static View getTreeNodeParentView(View view) {
        EAnnotation xmiIdAnnotation = view.getEAnnotation(TREE_LAYOUT_ANNOTATION);
        if (xmiIdAnnotation != null) {
            return (View)view.eResource().getEObject((String)xmiIdAnnotation.getDetails().get((Object)TREE_NODE_PARENT_URI));
        }
        return null;
    }

    public static int getTreeNodePosition(IGraphicalEditPart editPart) {
        String pos;
        EAnnotation xmiIdAnnotation = editPart.getNotationView().getEAnnotation(TREE_LAYOUT_ANNOTATION);
        if (xmiIdAnnotation != null && (pos = (String)xmiIdAnnotation.getDetails().get((Object)TREE_NODE_POSITION)) != null) {
            return Integer.parseInt(pos);
        }
        return TreeLayoutUtil.getConstrainedTreeNodePosition(editPart.getFigure());
    }

    public static List<View> getViews(List<IGraphicalEditPart> editParts) {
        ArrayList<View> viewList = new ArrayList<View>();
        for (IGraphicalEditPart editPart : editParts) {
            viewList.add(editPart.getNotationView());
        }
        return viewList;
    }

    public static int getNewTreeNodePosition(Point location, List<IGraphicalEditPart> siblings) {
        int position = -1;
        if (siblings.isEmpty()) {
            return 0;
        }
        if (location != null) {
            int minPosDelta = Integer.MAX_VALUE;
            int minNegDelta = Integer.MIN_VALUE;
            int upperIndex = siblings.size() - 1;
            int lowerIndex = 0;
            int i = 0;
            while (i < siblings.size()) {
                IFigure figure = siblings.get(i).getFigure();
                Rectangle absoluteBounds = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)absoluteBounds);
                int deltaY = location.y - absoluteBounds.y;
                if (deltaY > 0 && deltaY < minPosDelta) {
                    if (siblings.size() == 1) {
                        lowerIndex = 1;
                        upperIndex = 1;
                    } else {
                        minPosDelta = deltaY;
                        lowerIndex = i;
                    }
                } else if (deltaY < 0 && deltaY > minNegDelta) {
                    if (siblings.size() == 1) {
                        lowerIndex = 0;
                        upperIndex = 0;
                    } else {
                        minNegDelta = deltaY;
                        upperIndex = i;
                    }
                }
                ++i;
            }
            if (lowerIndex == 0 && upperIndex == 0) {
                position = 0;
            } else if (lowerIndex < upperIndex || siblings.size() == 1 && lowerIndex == 1 && upperIndex == 1) {
                position = upperIndex;
            } else if (lowerIndex == siblings.size() - 1 && upperIndex == siblings.size() - 1) {
                position = upperIndex + 1;
            }
        }
        return position;
    }

    public static void setTreeNodesPositionAnnotation(List<View> viewElements) {
        if (viewElements != null) {
            int index = 0;
            while (index < viewElements.size()) {
                View view = viewElements.get(index);
                EAnnotation xmiIdAnnotation = view.getEAnnotation(TREE_LAYOUT_ANNOTATION);
                if (xmiIdAnnotation == null) {
                    xmiIdAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    xmiIdAnnotation.setSource(TREE_LAYOUT_ANNOTATION);
                }
                xmiIdAnnotation.getDetails().put((Object)TREE_NODE_POSITION, (Object)Integer.toString(index));
                xmiIdAnnotation.setEModelElement((EModelElement)view);
                ++index;
            }
        }
    }

    public static void setTreeNodeParentAnnotation(View child, View parent) {
        EAnnotation xmiIdAnnotation = child.getEAnnotation(TREE_LAYOUT_ANNOTATION);
        if (xmiIdAnnotation == null) {
            xmiIdAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            xmiIdAnnotation.setSource(TREE_LAYOUT_ANNOTATION);
        }
        xmiIdAnnotation.getDetails().put((Object)TREE_NODE_PARENT_URI, (Object)parent.eResource().getURIFragment((EObject)parent));
        xmiIdAnnotation.setEModelElement((EModelElement)child);
    }

    public static List<Connection> getTreeFigureIncomingConnections(ConnectionLayer connectionLayer, IFigure parentFigure) {
        List<Connection> connectionList = TreeLayoutUtil.getIncomingConnections(connectionLayer, parentFigure);
        ArrayList<Connection> indirectChildren = new ArrayList<Connection>();
        int parentFigureTreeLevel = TreeLayoutUtil.getDeepestTreeLevel(connectionLayer, parentFigure);
        for (Connection connection : connectionList) {
            IFigure childFigure = connection.getSourceAnchor().getOwner();
            int childTreeLevel = TreeLayoutUtil.getDeepestTreeLevel(connectionLayer, childFigure);
            if (childTreeLevel == parentFigureTreeLevel + 1) {
                Object object = parentFigure.getParent().getLayoutManager().getConstraint(childFigure);
                if (!(object instanceof TreeLayoutConstraint)) continue;
                TreeLayoutConstraint childConstraint = (TreeLayoutConstraint)((Object)object);
                IFigure constrainedParentFig = childConstraint.getTreeParentFigure();
                if (constrainedParentFig == null) {
                    childConstraint.setTreeParentFigure(parentFigure);
                    continue;
                }
                if (constrainedParentFig == parentFigure) continue;
                indirectChildren.add(connection);
                continue;
            }
            indirectChildren.add(connection);
        }
        connectionList.removeAll(indirectChildren);
        return connectionList;
    }

    private static int getDeepestTreeLevel(ConnectionLayer connectionLayer, IFigure figure) {
        List<Connection> connectionList = TreeLayoutUtil.getOutgoingConnections(connectionLayer, figure);
        if (connectionList.size() > 0) {
            int[] ret = new int[connectionList.size()];
            int i = 0;
            while (i < connectionList.size()) {
                ret[i] = 1 + TreeLayoutUtil.getDeepestTreeLevel(connectionLayer, connectionList.get(i).getTargetAnchor().getOwner());
                ++i;
            }
            int maxLevel = ret[0];
            if (ret.length > 1) {
                int i2 = 1;
                while (i2 < ret.length) {
                    if (ret[i2] > maxLevel) {
                        maxLevel = ret[i2];
                    }
                    ++i2;
                }
            }
            return maxLevel;
        }
        return 0;
    }

    public static List<Connection> getIncomingConnections(ConnectionLayer connectionLayer, IFigure figure) {
        ArrayList<Connection> incomingConnectionList = new ArrayList<Connection>();
        for (Object object : connectionLayer.getChildren()) {
            Connection connection;
            if (!(object instanceof Connection) || (connection = (Connection)object).getTargetAnchor().getOwner() != figure) continue;
            incomingConnectionList.add(connection);
        }
        return incomingConnectionList;
    }

    public static List<Connection> getOutgoingConnections(ConnectionLayer connectionLayer, IFigure figure) {
        ArrayList<Connection> outgoingConnectionList = new ArrayList<Connection>();
        for (Object object : connectionLayer.getChildren()) {
            Connection connection;
            if (!(object instanceof Connection) || (connection = (Connection)object).getSourceAnchor().getOwner() != figure) continue;
            outgoingConnectionList.add(connection);
        }
        return outgoingConnectionList;
    }
}

