/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.treelayout.commands;

import com.yakindu.base.gmf.runtime.treelayout.TreeLayoutUtil;
import com.yakindu.base.gmf.runtime.treelayout.UIUtils;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class UpdateAnnotationsOnReorientRelationshipCommand
extends AbstractTransactionalCommand {
    private final ReorientRelationshipRequest request;
    private final IGraphicalEditPart sourceEditPart;

    public UpdateAnnotationsOnReorientRelationshipCommand(ReorientRelationshipRequest request, IGraphicalEditPart sourceEditPart) {
        super(request.getEditingDomain(), request.getLabel(), null);
        this.request = request;
        this.sourceEditPart = sourceEditPart;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IGraphicalEditPart newEnd;
        IGraphicalEditPart oldEnd = UIUtils.getEditPart(this.request.getOldRelationshipEnd());
        if (oldEnd != null) {
            ArrayList<IGraphicalEditPart> treeChildren = TreeLayoutUtil.getOrderedTreeChildren(oldEnd);
            treeChildren.remove(this.sourceEditPart);
            TreeLayoutUtil.setTreeNodesPositionAnnotation(TreeLayoutUtil.getViews(treeChildren));
        }
        if ((newEnd = UIUtils.getEditPart(this.request.getNewRelationshipEnd())) != null) {
            ArrayList<IGraphicalEditPart> treeChildren = TreeLayoutUtil.getOrderedTreeChildren(newEnd);
            treeChildren.add(this.sourceEditPart);
            TreeLayoutUtil.setTreeNodesPositionAnnotation(TreeLayoutUtil.getViews(treeChildren));
            TreeLayoutUtil.setTreeNodeParentAnnotation(this.sourceEditPart.getNotationView(), newEnd.getNotationView());
        }
        return CommandResult.newOKCommandResult();
    }
}

