/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.scxml.qt.files;

import com.google.inject.Inject;
import com.yakindu.base.types.Parameter;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.scxml.qt.extensions.QtNamingExtensions;
import com.yakindu.sctunit.generator.scxml.qt.extensions.QtStatementExtensions;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TestClassSource {
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    @Inject
    @Extension
    private QtNamingExtensions _qtNamingExtensions;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private QtStatementExtensions _qtStatementExtensions;
    protected GeneratorEntry entry;

    public void generate(GeneratorEntry it, IFileSystemAccess fsa) {
        SCTUnitElement sctUnitElement = this._baseNavigationExtensions.getSCTUnitElement(it);
        if (!(sctUnitElement instanceof SCTUnitClass)) {
            return;
        }
        SCTUnitClass it_1 = (SCTUnitClass)sctUnitElement;
        this.generate(it_1, fsa);
    }

    public void generate(SCTUnitClass it, IFileSystemAccess fsa) {
        fsa.generateFile(this.filename(it), this.content(it));
    }

    public String filename(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("QtSCTUnit/src/");
        String _cpp = this._qtNamingExtensions.cpp(this._qtNamingExtensions.testClassName((SCTUnitElement)it).toLowerCase());
        _builder.append(_cpp);
        return _builder.toString();
    }

    public CharSequence content(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"");
        String _lowerCase = this._qtNamingExtensions.h(this._qtNamingExtensions.testClassName((SCTUnitElement)it)).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("void ");
        String _testClassName = this._qtNamingExtensions.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append("::init(){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sm = QSharedPointer<");
        String _name = it.getStatechart().getName();
        _builder.append(_name, "\t");
        _builder.append(">::create();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("AbstractQtUnitTest::init(sm);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it_1 -> {
            boolean _isIgnore = this._baseNavigationExtensions.isIgnore(it_1);
            return !_isIgnore;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this._baseNavigationExtensions.getSCTUnitOperations(it), (Functions.Function1)_function);
        for (SCTUnitOperation operation : _filter) {
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(operation.getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _testClassName_1 = this._qtNamingExtensions.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName_1);
            _builder.append("::");
            String _name_1 = operation.getName();
            _builder.append(_name_1);
            _builder.append("(");
            CharSequence _generateParameter = this.generateParameter(operation);
            _builder.append((Object)_generateParameter);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            boolean _isTest = this._baseNavigationExtensions.isTest((EObject)operation);
            if (_isTest) {
                _builder.append("\t");
                _builder.append("init();");
                _builder.newLine();
            }
            EList _code = operation.getBody().getCode();
            for (TestStatement statement : _code) {
                _builder.append("\t");
                CharSequence _generate = this._qtStatementExtensions.generate(statement);
                _builder.append((Object)_generate, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateParameter(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(param.getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _name = param.getName();
            _builder.append(_name);
        }
        return _builder;
    }
}

