/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.generic.editor;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.yakindu.base.expressions.expressions.Guard;
import com.yakindu.sct.domain.extension.IModuleProvider;
import com.yakindu.sct.domain.generic.editor.EntryRuleRuntimeModule;
import com.yakindu.sct.domain.generic.editor.EntryRuleUIModule;
import com.yakindu.sct.domain.generic.editor.GenericEditorModule;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.stext.STextRuntimeModule;
import com.yakindu.sct.model.stext.stext.StateSpecification;
import com.yakindu.sct.model.stext.stext.StatechartSpecification;
import com.yakindu.sct.model.stext.stext.TransitionSpecification;
import com.yakindu.sct.model.stext.ui.STextUiModule;
import com.yakindu.sct.model.stext.ui.internal.StextActivator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;

public class EditorModuleProvider
implements IModuleProvider {
    private static final ImmutableMap<String, Class<? extends EObject>> GRAMMAR_RULE_MAP = ImmutableMap.of((Object)Statechart.class.getName(), StatechartSpecification.class, (Object)Transition.class.getName(), TransitionSpecification.class, (Object)State.class.getName(), StateSpecification.class, (Object)Guard.class.getName(), Guard.class);

    public Module getModule(String ... options) {
        if (options.length == 0) {
            return new GenericEditorModule();
        }
        String semanticTarget = options[0];
        if (!GRAMMAR_RULE_MAP.containsKey((Object)semanticTarget)) {
            throw new IllegalArgumentException(String.format("No grammar rule for semantic target '%s' found", semanticTarget));
        }
        return this.getEmbeddedEditorModule(semanticTarget);
    }

    protected Module getEmbeddedEditorModule(String semanticTarget) {
        Class rule = (Class)GRAMMAR_RULE_MAP.get((Object)semanticTarget);
        return Modules.override((Module[])new Module[]{this.getLanguageModule()}).with(new Module[]{new EntryRuleRuntimeModule(rule), new EntryRuleUIModule(rule)});
    }

    protected Module getLanguageModule() {
        Module languageModule = Modules.override((Module[])new Module[]{this.getLanguageRuntimeModule()}).with(new Module[]{this.getLanguageUiModule()});
        return Modules.override((Module[])new Module[]{languageModule}).with(new Module[]{new SharedStateModule()});
    }

    protected Module getLanguageUiModule() {
        return new STextUiModule((AbstractUIPlugin)StextActivator.getInstance());
    }

    protected Module getLanguageRuntimeModule() {
        return new STextRuntimeModule();
    }
}

