/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.yakindu.sctunit.SCTUnitStandaloneSetup;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class Main {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private IGenerator generator;
    @Inject
    private JavaIoFileSystemAccess fileAccess;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Aborting: no path to EMF resource provided!");
            return;
        }
        Injector injector = new SCTUnitStandaloneSetup().createInjectorAndDoEMFRegistration();
        Main main = (Main)injector.getInstance(Main.class);
        main.runGenerator(args[0]);
    }

    protected void runGenerator(String string) {
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        Resource resource = set.getResource(URI.createURI((String)string), true);
        List list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!list.isEmpty()) {
            for (Issue issue : list) {
                System.err.println(issue);
            }
            return;
        }
        this.fileAccess.setOutputPath("src-gen/");
        this.generator.doGenerate(resource, (IFileSystemAccess)this.fileAccess);
        System.out.println("Code generation finished.");
    }
}

