/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.inferrer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.yakindu.base.expressions.inferrer.ExpressionsTypeInferrer;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.inferrer.AbstractTypeSystemInferrer;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sctunit.inferrer.TypesProvider;
import com.yakindu.sctunit.sCTUnit.CodeBlock;
import com.yakindu.sctunit.sCTUnit.EnterExpression;
import com.yakindu.sctunit.sCTUnit.ExitExpression;
import com.yakindu.sctunit.sCTUnit.ExpressionStatement;
import com.yakindu.sctunit.sCTUnit.IfStatement;
import com.yakindu.sctunit.sCTUnit.ProceedExpression;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.StatechartActiveExpression;
import com.yakindu.sctunit.sCTUnit.StatechartFinalExpression;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class SCTUnitTypeInferrer
extends AbstractTypeSystemInferrer {
    @Inject
    private TypesProvider delegateProvider;
    public static final String NO_RETURN_TYPE_INFERRED = "Could not infer common return type from operation's return statements";

    public ITypeSystemInferrer.InferenceResult doInfer(EObject object) {
        ITypeSystemInferrer inferrer = this.delegateProvider.getTypeSystemInferrer(object);
        ((AbstractTypeSystemInferrer)inferrer).initDispatcher((List)Lists.newArrayList((Object[])new ITypeSystemInferrer[]{this, inferrer}));
        return inferrer.infer(object, this.acceptor);
    }

    protected ITypeSystemInferrer.InferenceResult getResultFor(String name, EObject context) {
        return ITypeSystemInferrer.InferenceResult.from((Type)this.delegateProvider.getTypeSystem(context).getType(name));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Statechart sct) {
        return this.getResultFor("void", (EObject)sct);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(StatechartActiveExpression exp) {
        return this.getResultFor("boolean", (EObject)exp);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(StatechartFinalExpression exp) {
        return this.getResultFor("boolean", (EObject)exp);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(SCTUnitOperation operation) {
        if (operation.getTypeSpecifier() == null) {
            return this.inferTypeFromReturnStatements(operation.getBody());
        }
        return this.doInfer((EObject)operation.getTypeSpecifier());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(EnterExpression exp) {
        return this.getResultFor("void", (EObject)exp);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ExitExpression exp) {
        return this.getResultFor("void", (EObject)exp);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ProceedExpression exp) {
        ITypeSystemInferrer.InferenceResult valueType = this.doInfer((EObject)exp.getValue());
        this.assertAssignable(this.getResultFor("integer", (EObject)exp), valueType, null);
        return this.getResultFor("void", (EObject)exp);
    }

    protected ITypeSystemInferrer.InferenceResult inferTypeFromReturnStatements(CodeBlock body) {
        if (body.getCode().isEmpty()) {
            return this.getResultFor("void", body);
        }
        List returnStatements = EcoreUtil2.getAllContentsOfType((EObject)body, ReturnStatement.class);
        if (returnStatements.isEmpty()) {
            return this.getResultFor("void", body);
        }
        ITypeSystemInferrer.InferenceResult returnType = this.doInfer((ReturnStatement)returnStatements.get(0));
        int i = 1;
        while (i < returnStatements.size()) {
            ITypeSystemInferrer.InferenceResult next = this.doInfer((ReturnStatement)returnStatements.get(i));
            if ((returnType = this.getCommonType(returnType, next)) == null) {
                return this.getResultFor("void", body);
            }
            ++i;
        }
        return returnType;
    }

    protected boolean containsReturnStatement(TestStatement lastStatement) {
        return !EcoreUtil2.getAllContentsOfType((EObject)lastStatement, ReturnStatement.class).isEmpty();
    }

    protected ITypeSystemInferrer.InferenceResult getCommonType(ITypeSystemInferrer.InferenceResult left, ITypeSystemInferrer.InferenceResult right) {
        this.assertCompatible(left, right, NO_RETURN_TYPE_INFERRED);
        return super.getCommonType(left, right);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ReturnStatement returnStatement) {
        if (returnStatement.getReturnValue() != null) {
            return this.inferTypeDispatch((EObject)returnStatement.getReturnValue());
        }
        return this.getResultFor("void", returnStatement);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ExpressionStatement expressionStatement) {
        return this.inferTypeDispatch((EObject)expressionStatement.getExpression());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TestStatement stm) {
        return this.getResultFor("void", stm);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(IfStatement ifStatement) {
        Type commonType;
        boolean result2IsVoid;
        ITypeSystem typeSystem = this.delegateProvider.getTypeSystem(ifStatement);
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)Iterables.getLast(ifStatement.getThen().getCode()));
        ITypeSystemInferrer.InferenceResult result2 = ifStatement.getElse() == null || ifStatement.getElse().getCode().isEmpty() ? this.getResultFor("void", ifStatement) : this.inferTypeDispatch((EObject)Iterables.getLast(ifStatement.getElse().getCode()));
        boolean result1IsVoid = result1 == null || typeSystem.isSame(result1.getType(), typeSystem.getType("void"));
        boolean bl = result2IsVoid = result2 == null || typeSystem.isSame(result2.getType(), typeSystem.getType("void"));
        if (result1IsVoid || result2IsVoid) {
            return this.getResultFor("void", ifStatement);
        }
        if (ifStatement.getElse() != null && !ifStatement.getElse().getCode().isEmpty()) {
            boolean falseHasReturn = Iterables.getLast(ifStatement.getElse().getCode()) instanceof ReturnStatement;
            boolean trueHasReturn = Iterables.getLast(ifStatement.getThen().getCode()) instanceof ReturnStatement;
            if (trueHasReturn && falseHasReturn || !trueHasReturn && !falseHasReturn) {
                this.assertCompatible(result1, result2, String.format("Could not determine a common type for %s and %s.", result1, result2));
            }
        }
        return (commonType = typeSystem.getCommonType(result1.getType(), result2.getType())) != null ? ITypeSystemInferrer.InferenceResult.from((Type)commonType) : this.getResultFor("void", ifStatement);
    }

    public Map<TypeParameter, ITypeSystemInferrer.InferenceResult> validateParameters(Map<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping, Operation operation, List<Argument> args, IValidationIssueAcceptor acceptor) {
        if (args.size() == 0) {
            return Maps.newHashMap();
        }
        ExpressionsTypeInferrer delegateInferrer = (ExpressionsTypeInferrer)this.delegateProvider.getTypeSystemInferrer((EObject)args.get(0));
        return delegateInferrer.validateParameters(typeParameterMapping, operation, args, acceptor);
    }
}

