/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.validation;

import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sctunit.sCTUnit.AssertionStatement;
import com.yakindu.sctunit.validation.BaseSCTUnitValidator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class AssertionStatementValidator
extends BaseSCTUnitValidator {
    @Check
    public void checkAssertionStatement(AssertionStatement statement) {
        Expression expression = statement.getExpression();
        ITypeSystemInferrer ti = this.typeInferrer;
        ITypeSystem ts = this.getTypeSystem(statement);
        try {
            if (!ts.isSame(ti.infer((EObject)expression).getType(), ts.getType("boolean"))) {
                this.error("Assertion statement must evaluate to type 'boolean'", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkEventNotIn(AssertionStatement statement) {
        List contents = EcoreUtil2.eAllOfType((EObject)statement, FeatureCall.class);
        List contents2 = EcoreUtil2.eAllOfType((EObject)statement, ElementReferenceExpression.class);
        ArrayList<EventDefinition> edlist = new ArrayList<EventDefinition>();
        for (FeatureCall fc : contents) {
            if (!(fc.getFeature() instanceof EventDefinition)) continue;
            edlist.add((EventDefinition)fc.getFeature());
        }
        for (ElementReferenceExpression er : contents2) {
            if (!(er.getReference() instanceof EventDefinition)) continue;
            edlist.add((EventDefinition)er.getReference());
        }
        try {
            for (EventDefinition ed : edlist) {
                if (!ed.getDirection().getLiteral().equals("in")) continue;
                this.error("Assertions on in-events are not allowed", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

