/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.validation;

import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.inferrer.SCTUnitTypeInferrer;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.SCTUnitPackage;
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement;
import com.yakindu.sctunit.validation.BaseSCTUnitValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class MockingStatementValidator
extends BaseSCTUnitValidator {
    @Check
    public void checkVerifyExpressionsNumberOfArguments(VerifyCalledStatement statement) {
        Operation op = this.getOperation(statement.getReference());
        if (this.getParams(statement.getReference()).size() > 0) {
            this.assertOperationArguments(op, this.getParams(statement.getReference()));
        }
    }

    public void assertOperationArguments(Operation operation, List<Expression> args) {
        EList parameters = operation.getParameters();
        if (operation.isVariadic() && operation.getVarArgIndex() > args.size() || !operation.isVariadic() && parameters.size() != args.size()) {
            this.error(String.format("Wrong number of arguments, expected %s .", parameters), null, "WrongNrOfArgs", new String[0]);
        }
    }

    @Check
    public void checkNegativeVerifyCalledNoTimes(VerifyCalledStatement statement) {
        if (statement.isNegated() && statement.getTimes() != null) {
            this.error("Using \"assert ! called\" with \"times\" is not allowed!", null);
        }
    }

    @Check
    public void checkVerifyExpressionArguments(VerifyCalledStatement statement) {
        ITypeSystemInferrer ti = this.typeInferrer;
        Operation op = this.getOperation(statement.getReference());
        ti.infer((EObject)op, (IValidationIssueAcceptor)this);
        List<Argument> args = this.argumentExpression(statement.getReference()).map(e -> e.getArguments()).orElse(Collections.emptyList());
        ((SCTUnitTypeInferrer)ti).validateParameters(Collections.emptyMap(), op, args, this);
    }

    @Check
    public void checkMockingStatement(MockReturnStatement statement) {
        Type paramType;
        ITypeSystemInferrer ti = this.typeInferrer;
        ITypeSystem ts = this.getTypeSystem(statement);
        Operation op = this.getOperation(statement.getReference());
        if (op == null) {
            this.error("The mocking statement must be an operation.", (EStructuralFeature)SCTUnitPackage.Literals.MOCKING_STATEMENT__REFERENCE);
            return;
        }
        Type returntype = ti.infer((EObject)op).getType();
        if (!ts.isSuperType(returntype, paramType = ti.infer((EObject)statement.getValue()).getType())) {
            String rType = returntype.getName();
            String pType = paramType.getName();
            this.error(String.format("The value type %s doesn't match the return type %s of the operation", pType, rType), null);
        }
    }

    @Check
    public void checkReturnsIsRequired(MockReturnStatement stm) {
        ITypeSystem ts = this.getTypeSystem(stm);
        if (stm.getValue() == null && !ts.isVoid(this.typeInferrer.infer((EObject)stm.getReference()).getType())) {
            this.error("Operations that are not of type 'void' require a 'returns' statement.", (EStructuralFeature)SCTUnitPackage.Literals.MOCKING_STATEMENT__REFERENCE);
        }
    }

    @Check
    public void checkOnlyGlobalConstUsedInReturnStatement(MockReturnStatement statement) {
        Expression returnExpr = statement.getValue();
        ArgumentExpression ref = this.getReferenceToLocalNonConstElement((EObject)returnExpr);
        if (ref != null) {
            this.error("Only global constants are allowed in mock return statements.", statement, (EStructuralFeature)SCTUnitPackage.Literals.MOCK_RETURN_STATEMENT__VALUE);
        }
        TreeIterator iter = returnExpr.eAllContents();
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            ref = this.getReferenceToLocalNonConstElement(next);
            if (ref == null) continue;
            this.error("Only global constants are allowed in mock return statements.", statement, (EStructuralFeature)SCTUnitPackage.Literals.MOCK_RETURN_STATEMENT__VALUE);
        }
    }

    protected ArgumentExpression getReferenceToLocalNonConstElement(EObject e) {
        VariableDefinition varDef;
        ArgumentExpression argumentExpression;
        EObject reference;
        if (e instanceof ArgumentExpression && ((reference = this.getReferenceOrFeature(argumentExpression = (ArgumentExpression)e)) instanceof VariableDefinition ? !(varDef = (VariableDefinition)reference).isConst() || !this.isGlobal(varDef) : !(reference instanceof SCTUnitOperation) && !(reference instanceof Type) && !(reference instanceof Enumerator))) {
            return argumentExpression;
        }
        return null;
    }

    protected EObject getReferenceOrFeature(ArgumentExpression exp) {
        if (exp instanceof ElementReferenceExpression) {
            return ((ElementReferenceExpression)exp).getReference();
        }
        if (exp instanceof FeatureCall) {
            return ((FeatureCall)exp).getFeature();
        }
        return null;
    }

    protected boolean isGlobal(VariableDefinition varDef) {
        EObject container = varDef.eContainer();
        while (container != null) {
            if (container instanceof SCTUnitOperation) {
                return false;
            }
            if (container instanceof SCTUnitClass) {
                return true;
            }
            container = container.eContainer();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Operation getOperation(Expression expr) {
        Operation element = null;
        if (expr instanceof ElementReferenceExpression) {
            EObject reference = ((ElementReferenceExpression)expr).getReference();
            if (!(reference instanceof Operation)) return null;
            return (Operation)reference;
        }
        if (!(expr instanceof FeatureCall)) return element;
        EObject reference = ((FeatureCall)expr).getFeature();
        if (!(reference instanceof Operation)) return null;
        return (Operation)reference;
    }

    protected Optional<ArgumentExpression> argumentExpression(Expression e) {
        if (e instanceof ArgumentExpression) {
            return Optional.of((ArgumentExpression)e);
        }
        return Optional.empty();
    }

    protected List<Expression> getParams(Expression expr) {
        ArrayList<Expression> params = new ArrayList<Expression>();
        Optional<ArgumentExpression> argumentExpression = this.argumentExpression(expr);
        argumentExpression.ifPresent(e -> {
            EList expressions = e.getExpressions();
            if (expressions != null) {
                params.addAll((Collection<Expression>)expressions);
            }
        });
        return params;
    }
}

