/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.validation;

import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.ParenthesizedExpression;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.sCTUnit.AssertionStatement;
import com.yakindu.sctunit.sCTUnit.IfStatement;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.validation.BaseSCTUnitValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class SCTUnitExpressionsValidator
extends BaseSCTUnitValidator {
    @Check
    public void checkIfCondition(IfStatement expr) {
        Expression expression = expr.getCondition();
        ITypeSystemInferrer ti = this.typeInferrer;
        ITypeSystem ts = this.getTypeSystem(expr);
        try {
            if (!ts.isSuperType(ti.infer((EObject)expression, (IValidationIssueAcceptor)this).getType(), ts.getType("boolean"))) {
                this.error("If-condition must evaluate to type 'boolean'", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkInternalAccess(ElementReferenceExpression exp) {
        try {
            if (!(exp.getReference() instanceof Operation) && exp.getReference().eContainer() instanceof InternalScope) {
                this.error("Internal variables or events are not accessible", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkOutEventRaising(EventRaisingExpression exp) {
        FeatureCall fcExp;
        EventDefinition edExp;
        ElementReferenceExpression erExp;
        Direction dir = null;
        if (exp.getEvent() instanceof ElementReferenceExpression && (erExp = (ElementReferenceExpression)exp.getEvent()).getReference() instanceof EventDefinition) {
            edExp = (EventDefinition)erExp.getReference();
            dir = edExp.getDirection();
        }
        if (exp.getEvent() instanceof FeatureCall && (fcExp = (FeatureCall)exp.getEvent()).getFeature() instanceof EventDefinition) {
            edExp = (EventDefinition)fcExp.getFeature();
            dir = edExp.getDirection();
        }
        if (dir != null && dir.getLiteral().equals("out")) {
            this.error("It is not possible to raise out-events", null);
        }
    }

    @Check
    public void checkExpressionStatementOperationSelfCall(ElementReferenceExpression expression) {
        if (expression.getReference() instanceof SCTUnitOperation) {
            SCTUnitOperation op = (SCTUnitOperation)EcoreUtil2.getContainerOfType((EObject)expression, SCTUnitOperation.class);
            SCTUnitOperation ref = (SCTUnitOperation)expression.getReference();
            if (ref.getName().equals(op.getName())) {
                this.error("Recursion is not allowed", null);
            }
        }
    }

    @Check
    public void checkSameStatechartReferenceForExternalOperationCall(ElementReferenceExpression expression) {
        if (expression.getReference() instanceof SCTUnitOperation) {
            SCTUnitClass clazz = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)expression, SCTUnitClass.class);
            SCTUnitOperation ref = (SCTUnitOperation)expression.getReference();
            this.checkForSameStatecharRef(clazz, ref);
        }
    }

    @Check
    public void checkSameStatechartReferenceForExternalOperationCall(FeatureCall expression) {
        if (expression.getFeature() instanceof SCTUnitOperation) {
            SCTUnitClass clazz = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)expression, SCTUnitClass.class);
            SCTUnitOperation ref = (SCTUnitOperation)expression.getFeature();
            this.checkForSameStatecharRef(clazz, ref);
        }
    }

    @Check
    public void checkPrimitivTypeVariableCreationIsInitialized(VariableDefinition expression) {
        if (expression.getType() instanceof PrimitiveType && expression.getInitialValue() == null) {
            this.error("A variable of a primitive type has to be initialized", null);
        }
    }

    @Check
    public void checkStatechartVariablesAssignmentsNotAllowedInMockReturns(AssignmentExpression expression) {
        boolean isInMockReturn;
        boolean bl = isInMockReturn = EcoreUtil2.getContainerOfType((EObject)expression, MockReturnStatement.class) != null;
        if (this.isStatechartVar(expression.getVarRef()) && isInMockReturn) {
            this.error("Statechart variable assignments are not allowed in mock return statements", null);
        }
    }

    @Check
    public void checkStatechartVariablesAssignmentInAssertion(AssignmentExpression expression) {
        boolean isInAssertion;
        boolean bl = isInAssertion = EcoreUtil2.getContainerOfType((EObject)expression, AssertionStatement.class) != null;
        if (this.isStatechartVar(expression.getVarRef()) && isInAssertion) {
            this.error("Statechart variable assignment is not allowed in an assertion", null);
        }
    }

    @Check
    public void checkStatechartVariablesAssignmentsInComplexExpression(AssignmentExpression expression) {
        boolean isSimpleExpression = this.isSimpleExpression((Expression)expression);
        if (!isSimpleExpression) {
            this.error("Statechart variable assignments are only allowed as simple statements", null);
        }
    }

    @Check
    public void checkStatechartVariableAssignmentInReturnStatement(AssignmentExpression expression) {
        boolean isInReturnStatement;
        boolean bl = isInReturnStatement = EcoreUtil2.getContainerOfType((EObject)expression, ReturnStatement.class) != null;
        if (this.isStatechartVar(expression.getVarRef()) && isInReturnStatement) {
            this.error("Statechart variable assignment is not allowed in return statement", null);
        }
    }

    protected boolean isStatechartVar(Expression varRef) {
        if (varRef instanceof ElementReferenceExpression) {
            return this.isStatechartVar((ElementReferenceExpression)varRef);
        }
        if (varRef instanceof FeatureCall) {
            return this.isStatechartVar((FeatureCall)varRef);
        }
        return false;
    }

    protected boolean isStatechartVar(ElementReferenceExpression varRef) {
        return EcoreUtil2.getContainerOfType((EObject)varRef.getReference(), Statechart.class) != null;
    }

    protected boolean isStatechartVar(FeatureCall varRef) {
        return EcoreUtil2.getContainerOfType((EObject)varRef.getFeature(), Statechart.class) != null;
    }

    protected boolean isSimpleExpression(Expression expr) {
        if (expr.eContainer() instanceof TestStatement) {
            return true;
        }
        if (expr.eContainer() instanceof ParenthesizedExpression) {
            return this.isSimpleExpression((Expression)((ParenthesizedExpression)expr.eContainer()));
        }
        return false;
    }

    private void checkForSameStatecharRef(SCTUnitClass clazz, SCTUnitOperation ref) {
        SCTUnitClass refClazz = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)ref, SCTUnitClass.class);
        if (!clazz.getStatechart().equals(refClazz.getStatechart())) {
            this.error("Called operation must be defined in same statechart context", null);
        }
    }
}

