/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.templates;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.GeneratorExtensions;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.generator.core.extensions.ILibraryDescriptor;
import com.yakindu.sct.generator.core.extensions.LibraryExtensions;
import com.yakindu.sct.generator.core.library.IDefaultFeatureValueProvider;
import com.yakindu.sct.generator.genmodel.services.SGenGrammarAccess;
import com.yakindu.sct.generator.genmodel.ui.internal.GenmodelActivator;
import com.yakindu.sct.generator.genmodel.ui.templates.SGenProposalCreator;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sct.model.sgen.GeneratorModel;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider;

public class SGenTemplateProposalProvider
extends DefaultTemplateProposalProvider {
    @Inject
    private SGenGrammarAccess gaccess;
    @Inject
    private SGenProposalCreator creator;
    private final ContextTypeIdHelper helper;

    @Inject
    public SGenTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.helper = helper;
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        super.createTemplates(templateContext, context, acceptor);
        String id = this.helper.getId((AbstractRule)this.gaccess.getFeatureConfigurationRule());
        boolean _equals = templateContext.getContextType().getId().equals(id);
        if (_equals) {
            this.createFeatureConfigurationTemplates(templateContext, context, acceptor);
        }
    }

    private void createFeatureConfigurationTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        boolean _not;
        GeneratorModel model = (GeneratorModel)EcoreUtil2.getContainerOfType((EObject)context.getCurrentModel(), GeneratorModel.class);
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        boolean _isPresent = generatorDescriptor.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            return;
        }
        ILibraryDescriptor libraryDescriptor = LibraryExtensions.getLibraryDescriptor((String)((IGeneratorDescriptor)generatorDescriptor.get()).getLibraryID());
        FeatureTypeLibrary library = libraryDescriptor.getFeatureTypeLibrary();
        IDefaultFeatureValueProvider valueProvider = this.getValueProvider(libraryDescriptor);
        Consumer<FeatureType> _function = type -> {
            Template template = this.createTemplate((FeatureType)type, valueProvider, context);
            TemplateProposal proposal = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(proposal);
        };
        library.getTypes().forEach(_function);
    }

    private IDefaultFeatureValueProvider getValueProvider(ILibraryDescriptor desc) {
        return desc.createFeatureValueProvider(GenmodelActivator.getInstance().getInjector("com.yakindu.sct.generator.genmodel.SGen"));
    }

    private Template createTemplate(FeatureType type, IDefaultFeatureValueProvider provider, ContentAssistContext context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = type.getName();
        _builder.append(_name);
        _builder.append(" feature");
        String _string = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Creates feature ");
        String _name_1 = type.getName();
        _builder_1.append(_name_1);
        String _string_1 = _builder_1.toString();
        String _name_2 = type.getName();
        String _createProposal = this.creator.createProposal(type, provider, context.getCurrentModel());
        return new Template(_string, _string_1, _name_2, _createProposal, false);
    }
}

