/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.wizard;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;

public class TreeExpandingDoubleClickListener
implements IDoubleClickListener {
    private final CheckboxTreeViewer treeViewer;
    private final ICheckStateListener checkStateListener;

    public TreeExpandingDoubleClickListener(CheckboxTreeViewer treeViewer, ICheckStateListener checkStateListener) {
        this.treeViewer = treeViewer;
        this.checkStateListener = checkStateListener;
    }

    public TreeExpandingDoubleClickListener(CheckboxTreeViewer treeViewer) {
        this(treeViewer, null);
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object firstElement = selection.getFirstElement();
        if (this.treeViewer.isExpandable(firstElement)) {
            boolean expanded = this.treeViewer.getExpandedState(firstElement);
            this.treeViewer.setExpandedState(firstElement, !expanded);
        } else {
            boolean newState = !this.treeViewer.getChecked(firstElement);
            this.treeViewer.setChecked(firstElement, newState);
            if (this.checkStateListener != null) {
                this.checkStateListener.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.treeViewer, firstElement, newState));
            }
        }
    }
}

