/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.web.integration.resource;

import com.google.inject.Inject;
import com.yakindu.sct.json.transformation.json2xmi.JSONToXMITransformation;
import com.yakindu.sct.json.transformation.model.JsonHandler;
import com.yakindu.sct.json.transformation.model.JsonRoot;
import com.yakindu.sct.json.transformation.xmi2json.XMIToJSONTransformation;
import com.yakindu.sct.model.stext.resource.StextResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.util.StringInputStream;

public class WebResource
extends StextResource {
    @Inject
    private JsonHandler handler;
    @Inject
    private JSONToXMITransformation statechartTrafo;
    @Inject
    private XMIToJSONTransformation jsonTrafo;

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.getContents().clear();
        String content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        if (content.startsWith("<?xml")) {
            super.doLoad((InputStream)new StringInputStream(content), options);
            return;
        }
        Resource resource = this.statechartTrafo.transform(this.handler.fromJson(content), true);
        this.getContents().addAll((Collection)resource.getContents());
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        JsonRoot jsonModel = this.jsonTrafo.transform((Resource)this);
        String content = this.handler.toJson((Object)jsonModel);
        outputStream.write(content.getBytes(StandardCharsets.UTF_8));
    }
}

