/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.ui.handler;

import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.search.ui.utils.SearchUtils;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;

public abstract class AbstractSearchHandler
extends AbstractHandler {
    protected ISelection selection;
    protected List<EObject> elements;
    protected Resource eResource;
    protected STextExtensions utils = new STextExtensions();

    protected ISelection getSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPartSite site = window.getActivePage().getActiveEditor().getSite();
        if (site == null) {
            return null;
        }
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection == null) {
            return null;
        }
        return selection;
    }

    protected void unfoldSelection() throws Exception {
        this.selection = this.getSelection();
        if (this.selection == null) {
            throw new Exception("Illegal selection!");
        }
        this.elements = SearchUtils.getModelElement(this.selection);
        if (this.elements.size() > 1) {
            throw new Exception("Selection is not unambiguous!");
        }
        if (this.elements.isEmpty()) {
            throw new Exception("Could not find model element for selection!");
        }
        this.eResource = this.elements.get(0).eResource();
        if (this.eResource == null) {
            throw new Exception("Could not find resource for selection!");
        }
        if (this.eResource instanceof LazyLinkingResource) {
            Statechart sct = this.utils.getStatechart(this.eResource);
            if (sct == null) {
                throw new Exception("Could not find statechart for selection!");
            }
            this.eResource = sct.eResource();
            EObject equalElement = this.utils.findElement(this.elements.get(0), sct);
            if (equalElement == null) {
                throw new Exception("Could not find model element for selection!");
            }
            this.elements.set(0, equalElement);
        }
    }
}

