/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarSignatureVerifier {
    private Set<String> signed = new HashSet<String>();
    private Set<String> unsigned = new HashSet<String>();
    private JarFile jar;

    public JarSignatureVerifier(File file) throws IOException, SecurityException {
        this.analyzeJarSignatures(file);
    }

    protected void analyzeJarSignatures(File file) throws IOException, SecurityException {
        this.jar = new JarFile(file, true);
        Manifest man = this.jar.getManifest();
        for (Map.Entry<String, Attributes> entry : man.getEntries().entrySet()) {
            for (Object attrkey : entry.getValue().keySet()) {
                if (!(attrkey instanceof Attributes.Name) || ((Attributes.Name)attrkey).toString().indexOf("-Digest") == -1) continue;
                this.signed.add(entry.getKey());
            }
        }
        HashSet<String> entries = new HashSet<String>();
        Enumeration<JarEntry> entry = this.jar.entries();
        while (entry.hasMoreElements()) {
            JarEntry je = entry.nextElement();
            if (je.isDirectory()) continue;
            entries.add(je.getName());
            InputStream inputStream = this.jar.getInputStream(je);
            this.toByteArray(inputStream);
        }
        this.unsigned.clear();
        this.unsigned.addAll(entries);
        this.unsigned.removeAll(this.signed);
        HashSet<String> missing = new HashSet<String>(this.signed);
        missing.removeAll(entries);
        this.jar.close();
    }

    protected byte[] toByteArray(InputStream is) throws IOException, SecurityException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public JarFile getJarFile() {
        return this.jar;
    }

    public boolean isSigned() {
        if (!this.signed.isEmpty()) {
            HashSet<String> toRemove = new HashSet<String>();
            for (String entry : this.unsigned) {
                if (!entry.endsWith(".MF") && !entry.endsWith(".SF") && !entry.endsWith(".RSA")) continue;
                toRemove.add(entry);
            }
            HashSet<String> result = new HashSet<String>(this.unsigned);
            result.removeAll(toRemove);
            return result.isEmpty();
        }
        return false;
    }

    public Set<String> getSignedEntries() {
        return Collections.unmodifiableSet(this.signed);
    }

    public Set<String> getUnsignedEntries() {
        return Collections.unmodifiableSet(this.unsigned);
    }
}

