/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.utils;

import com.xformation.lmx.Lmx;
import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxHostid;
import com.xformation.lmx.LmxHostidType;
import com.xformation.lmx.LmxLicenseInfo;
import com.xformation.lmx.LmxLicenseType;
import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.EclipseLicenseManager;
import com.yakindu.licmgmt.internal.EclipseLicenseService;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.internal.utils.PathUtils;
import com.yakindu.licmgmt.utils.VersionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class LicenseHelper {
    private static final String USER_HOME_PATH = PathUtils.getUserHomePath().toLowerCase();
    private static final String USER_HOME_PATH_REPLACEMENT = "<user-home>/.YAKINDU";
    private static final String PRIVACY_POLICY = "Privacy policy:\nThe information contained in this file are exclusively used to analyze license problems. The file contains the data categories listed below.\n- Operating System\n- Java version\n- Paths to the license files (the user directory may be replaced by a placeholder)\n- License server URLs\n- License feature information: versions, type of licenses (server-based or file-based license), expiration date, licensee";
    private static final String PRIVACY_POLICY_HOST_ID = "- Host ID information:\n  - Hostname\n  - Username\n  - IP addresses\n  - Windows product ID\n  - Harddisk ID\n  - BIOS ID\n  - Ethernet MAC addresses\n  - Dongle ID\n  - Product ID\n  - AWS Instance ID\n  - Google Compute Engine\n  - Azure";
    private static final String INFO_TEMPLATE = "Diagnostic information about your system and your itemis product to analyse license issues.\n\nOS: %s\nJava: %s %s\nLicensemanagement: %s\nProduct: %s\nProduct Features: %s\nInstalled Licenses: %s\nHost IDs: %s\n%s\n%s";

    public static String getSupportInfos(boolean includeHostIds, Supplier<List<String>> getYakinduLicenseFeatures, IProgressMonitor monitor) throws InterruptedException {
        monitor.beginTask("Gathering license diagnostic information...", 10);
        String os = System.getProperty("os.name");
        String javaVersion = System.getProperty("java.version");
        String javaName = System.getProperty("java.runtime.name");
        LicenseHelper.checkMonitor(monitor, "Product and LMX Versions", 1);
        String licmgmtVersion = LicenseHelper.getLicmgmtVersion();
        String productAndApplication = LicenseHelper.getProductAndApplication();
        LicenseHelper.checkMonitor(monitor, "Host IDs", 1);
        String hostIds = includeHostIds ? LicenseHelper.getAllHostIds(monitor) : "<skipped>";
        LicenseHelper.checkMonitor(monitor, "Installed Licenses", 3);
        String lmxLicenseFeatures = LicenseHelper.getAllLmxLicenseFeatures(monitor);
        LicenseHelper.checkMonitor(monitor, "Installed itemis product features", 3);
        String yakinduLicenseFeatures = getYakinduLicenseFeatures == null ? "<not loaded>" : LicenseHelper.asString("features", (Collection<String>)getYakinduLicenseFeatures.get());
        LicenseHelper.checkMonitor(monitor, "Done.", 1);
        return String.format(INFO_TEMPLATE, os, javaName, javaVersion, licmgmtVersion, productAndApplication, yakinduLicenseFeatures, lmxLicenseFeatures, hostIds, PRIVACY_POLICY, includeHostIds ? PRIVACY_POLICY_HOST_ID : "");
    }

    private static String getLicmgmtVersion() {
        String licmgmtVersion = VersionHelper.getLicmgmtVersion();
        int lmxVersion = new Lmx().getVersion();
        ServerSettings serverSettings = LicenseService.INSTANCE.getServerSettings();
        boolean trial = ((LicenseService)ILicenseService.INSTANCE).getSettings().isTrialEnabled();
        boolean autoBorrow = ((LicenseService)ILicenseService.INSTANCE).getSettings().isAutoBorrowingEnabled();
        return String.format("%s, %s, trials:%s, auto-borrow:%s, server: %s", licmgmtVersion, lmxVersion, trial, autoBorrow, serverSettings);
    }

    private static String getAllLmxLicenseFeatures(IProgressMonitor monitor) throws InterruptedException {
        List<IEclipseLicenseManager> managers = LicenseHelper.getLicenseManagersForAllPaths();
        if (managers.isEmpty()) {
            return "<no licensed product feature available>";
        }
        ArrayList<String> licenseInfos = new ArrayList<String>();
        for (IEclipseLicenseManager manager : managers) {
            licenseInfos.addAll(LicenseHelper.getAllLmxLicenseFeatures(manager, monitor));
        }
        return LicenseHelper.asString("licenses", licenseInfos);
    }

    private static List<String> getAllLmxLicenseFeatures(IEclipseLicenseManager manager, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<String> infos = new ArrayList<String>();
        List licenseInfos = manager.getLicenseInfos();
        for (LmxLicenseInfo license : licenseInfos) {
            String path = LicenseHelper.replaceUserHomePath(license.getPath());
            String vendor = license.getVendorName();
            String version = license.getVersion();
            LmxLicenseType licenseType = license.getLicenseType();
            LmxStatus status = license.getLmxStatus();
            for (LmxFeatureInfo feature : license.getFeatures()) {
                LicenseHelper.checkMonitor(monitor, null, 0);
                String actualExpireTime = feature.getActualExpireTime();
                int availableLicCount = feature.getAvailableLicCount();
                int usedLicCount = feature.getUsedLicCount();
                String comment = feature.getComment();
                String featureName = feature.getFeatureName();
                String licensee = feature.getLicensee();
                LmxLicenseType licenseType2 = feature.getLicenseType();
                String endDate = feature.getMaintenanceEndDate();
                String maintenanceEndDate = feature.getMaintenanceEndDate();
                String version2 = String.valueOf(feature.getMajorVer()) + "." + feature.getMinorVer();
                String path2 = LicenseHelper.replaceUserHomePath(feature.getPath());
                String serialNumber = feature.getSN();
                String options = feature.getOptions();
                String info = String.format("%s %s %s %s [%s%s%s%s] (end/expire/maintenance: %s/%s/%s%s%s%s)", vendor, featureName, version == null || version.isEmpty() || Objects.equals(version, version2) ? version : String.valueOf(version) + "/" + version2, licenseType == null || Objects.equals(licenseType, licenseType2) ? licenseType : licenseType + "/" + licenseType2, path == null || path.isEmpty() || Objects.equals(path, path2) ? path : String.valueOf(path) + "/" + path2, status == null || status == LmxStatus.LMX_SUCCESS ? "" : ", status: " + status, availableLicCount == 0 ? "" : ", available: " + usedLicCount + "/" + availableLicCount, options == null || options.trim().isEmpty() ? "" : ", options: " + options, endDate, actualExpireTime, maintenanceEndDate, comment == null || comment.isEmpty() ? "" : ", comment: '" + comment + "'", licensee == null || licensee.isEmpty() ? "" : ", licensee: '" + licensee + "'", serialNumber == null || serialNumber.isEmpty() ? "" : ", SN: '" + serialNumber + "'");
                infos.add(info);
            }
        }
        return infos;
    }

    private static String replaceUserHomePath(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.toLowerCase().startsWith(USER_HOME_PATH)) {
            return USER_HOME_PATH_REPLACEMENT + path.substring(USER_HOME_PATH.length());
        }
        return path;
    }

    private static List<IEclipseLicenseManager> getLicenseManagersForAllPaths() {
        HashSet paths = new HashSet();
        LinkedList<IEclipseLicenseManager> managers = new LinkedList<IEclipseLicenseManager>();
        for (IEclipseLicenseManager manager : EclipseLicenseService.INSTANCE.getAllEclipseLicenseManagers()) {
            LicenseManager licManager = (LicenseManager)((EclipseLicenseManager)manager).getLicenseManager();
            List addPaths = licManager.getAdditionalLicensePaths();
            if (managers.isEmpty()) {
                paths.addAll(addPaths);
                managers.add(manager);
                continue;
            }
            if (paths.containsAll(addPaths)) continue;
            if (addPaths.containsAll(paths)) {
                managers.clear();
            }
            managers.add(manager);
            paths.addAll(addPaths);
        }
        return managers;
    }

    private static String getAllHostIds(IProgressMonitor monitor) throws InterruptedException {
        if (EclipseLicenseService.INSTANCE.getAllEclipseLicenseManagers().isEmpty()) {
            return "<no license manager found>";
        }
        IEclipseLicenseManager manager = EclipseLicenseService.INSTANCE.getAllEclipseLicenseManagers().iterator().next();
        Lmx lmx = LicenseHelper.getLmx(manager);
        if (lmx == null) {
            return "<no lmx instance found>";
        }
        LinkedList<String> hostIds = new LinkedList<String>();
        LmxHostidType[] lmxHostidTypeArray = LmxHostidType.values();
        int n = lmxHostidTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LmxHostidType hostIdType = lmxHostidTypeArray[n2];
            if (hostIdType != LmxHostidType.LMX_HOSTID_ALL) {
                LicenseHelper.checkMonitor(monitor, "Host IDs: " + hostIdType, 0);
                try {
                    LmxHostid[] lmxHostIds;
                    LmxHostid[] lmxHostidArray = lmxHostIds = lmx.getHostid(hostIdType);
                    int n3 = lmxHostIds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        LmxHostid lmxHostid = lmxHostidArray[n4];
                        hostIds.add(String.format("Host ID [%s]: %s%s", hostIdType.name(), lmxHostid.getValue(), lmxHostid.getDescription() == null ? "" : " - " + lmxHostid.getDescription()));
                        LicenseHelper.checkMonitor(monitor, null, 0);
                        ++n4;
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    hostIds.add(String.format("<failed to retrieve %s host ids, %s: %s>", hostIdType.name(), e.getClass().getName(), LicenseHelper.formatException(e.getMessage())));
                }
            }
            ++n2;
        }
        return LicenseHelper.asString("IDs", hostIds);
    }

    private static String asString(String name, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return "<none>";
        }
        HashSet<String> distinctValues = new HashSet<String>(values);
        if (distinctValues.size() == 1) {
            return values.iterator().next();
        }
        return String.format("%d %s found:\n - %s\n", distinctValues.size(), name, distinctValues.stream().sorted().map(String::trim).collect(Collectors.joining("\n - ")));
    }

    private static Lmx getLmx(IEclipseLicenseManager manager) {
        ILicenseManager licenseManager = ((EclipseLicenseManager)manager).getLicenseManager();
        try {
            Field field = LicenseManager.class.getDeclaredField("lmx");
            field.setAccessible(true);
            Lmx lmx = (Lmx)field.get(licenseManager);
            field.setAccessible(false);
            return lmx;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getProductAndApplication() {
        if (!Platform.isRunning()) {
            return "<no Eclipse platform>";
        }
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "<no Eclipse product>";
        }
        String application = product.getApplication();
        Bundle productBundle = product.getDefiningBundle();
        return String.format("%s %s(%s) %s", product.getName(), application == null ? "" : "/ " + application + " ", product.getId(), productBundle == null ? "" : String.valueOf(productBundle.getSymbolicName()) + "_" + productBundle.getVersion());
    }

    private static Object formatException(String message) {
        if (message == null) {
            return null;
        }
        String trimmed = message.trim();
        String footer = "For further information go to http://www.x-formation.com";
        String msgWithoutFooter = trimmed.endsWith("For further information go to http://www.x-formation.com") ? trimmed.substring(0, trimmed.length() - "For further information go to http://www.x-formation.com".length()).trim() : trimmed;
        return msgWithoutFooter.replaceAll("\\R+", " ");
    }

    private static void checkMonitor(IProgressMonitor monitor, String task, int ticks) throws InterruptedException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (ticks > 0) {
            monitor.worked(ticks);
        }
        if (task != null) {
            monitor.subTask(task);
        }
    }
}

