/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.utils;

import com.yakindu.licmgmt.internal.LicenseManagementActivator;
import com.yakindu.licmgmt.internal.LoggingHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class LicenseUtils {
    public static String copyLicense(String licenseFile, String targetFolder) {
        File outputFile;
        File file = new File(licenseFile);
        if (!file.exists()) {
            return "The selected file does not exist.";
        }
        File targetFolderFile = new File(targetFolder);
        if (!targetFolderFile.exists()) {
            try {
                targetFolderFile.mkdir();
            }
            catch (SecurityException e) {
                LicenseManagementActivator.log(e.getMessage(), 4, e, false, false);
                return e.getMessage();
            }
        }
        if ((outputFile = new File(targetFolderFile, file.getName())).exists()) {
            outputFile.delete();
        }
        BufferedInputStream fileInputStream = null;
        BufferedOutputStream fileOutputStream = null;
        try {
            try {
                outputFile.createNewFile();
                fileOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                fileInputStream = new BufferedInputStream(new FileInputStream(file));
                int available = fileInputStream.available();
                while (available != 0) {
                    byte[] data = new byte[available];
                    int bytes = fileInputStream.read(data);
                    if (bytes <= 0) continue;
                    fileOutputStream.write(data);
                    available = fileInputStream.available();
                }
            }
            catch (IOException e) {
                String string = e.getMessage();
                LicenseUtils.closeQuietly(fileOutputStream);
                LicenseUtils.closeQuietly(fileInputStream);
                return string;
            }
        }
        catch (Throwable throwable) {
            LicenseUtils.closeQuietly(fileOutputStream);
            LicenseUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        LicenseUtils.closeQuietly(fileOutputStream);
        LicenseUtils.closeQuietly(fileInputStream);
        return null;
    }

    private static void closeQuietly(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LicenseManagementActivator.log(e.getMessage(), 1, e, false, false);
            }
        }
    }

    public static File getBundleLocation(String name) throws IOException, IllegalStateException {
        if (!Platform.isRunning()) {
            throw new IllegalStateException("Platform is not running");
        }
        Bundle bundle = Platform.getBundle((String)name);
        if (bundle == null) {
            throw new IllegalStateException("Bundle '" + name + "' not found in Platform");
        }
        try {
            File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
            if (bundleFile == null) {
                throw new IOException("Bundle '" + name + "' File is null");
            }
            LoggingHelper.info((String)"Bundle %s location %s / %s %s %s", (Object[])new Object[]{name, bundle.getLocation(), bundleFile.exists() ? "existing" : "non-existing", bundleFile.isDirectory() ? "directory" : "file", bundleFile});
            if (!bundleFile.exists()) {
                throw new IllegalStateException("Bundle '" + name + "' file does not exist: " + bundleFile);
            }
            if (!bundleFile.isFile()) {
                throw new IllegalStateException("Bundle '" + name + "' is expected to be a jar-file but it's not: " + bundleFile);
            }
            return bundleFile;
        }
        catch (IOException e) {
            LoggingHelper.error((String)"Bundle %s location unknown: %s", (Throwable)e, (Object[])new Object[]{name, bundle.getLocation()});
            throw new IOException("Failed to get jar-file path of Bundle '" + name + "': " + bundle.getLocation(), e);
        }
    }
}

