/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.json.transformation.json2xmi;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.adapter.ImplicitDefinitions;
import com.yakindu.sct.json.transformation.model.JsonCell;
import com.yakindu.sct.json.transformation.model.JsonChoice;
import com.yakindu.sct.json.transformation.model.JsonEntry;
import com.yakindu.sct.json.transformation.model.JsonExit;
import com.yakindu.sct.json.transformation.model.JsonFinal;
import com.yakindu.sct.json.transformation.model.JsonGraph;
import com.yakindu.sct.json.transformation.model.JsonNodeLabel;
import com.yakindu.sct.json.transformation.model.JsonNote;
import com.yakindu.sct.json.transformation.model.JsonRegion;
import com.yakindu.sct.json.transformation.model.JsonRoot;
import com.yakindu.sct.json.transformation.model.JsonState;
import com.yakindu.sct.json.transformation.model.JsonStatechart;
import com.yakindu.sct.json.transformation.model.JsonSynchronization;
import com.yakindu.sct.json.transformation.model.JsonTransition;
import com.yakindu.sct.json.transformation.model.JsonTransitionAnchor;
import com.yakindu.sct.json.transformation.model.JsonTransitionRouter;
import com.yakindu.sct.json.transformation.model.util.NodeModelFactory;
import com.yakindu.sct.json.transformation.model.util.NotationUtil;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.ChoiceKind;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.EntryKind;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.SGraphFactory;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JSONToXMITransformation {
    @Extension
    private SGraphFactory _sGraphFactory = SGraphFactory.eINSTANCE;
    @Extension
    private NotationFactory _notationFactory = NotationFactory.eINSTANCE;
    @Extension
    private NotationUtil _notationUtil = new NotationUtil();
    @Extension
    private NodeModelFactory _nodeModelFactory = new NodeModelFactory();
    @Extension
    private ImplicitDefinitions _implicitDefinitions = new ImplicitDefinitions();

    public Resource transform(JsonRoot root, boolean includeDiagram) {
        Resource _xblockexpression = null;
        Context context = new Context();
        context.graph = root.getGraph();
        Resource resource = this.transformRoot(root, context);
        if (includeDiagram) {
            this.transformDiagram(resource, context);
            Consumer<JsonNote> _function = it -> this.transformNote((JsonNote)it, (Diagram)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), Diagram.class)), context);
            Iterables.filter(root.getGraph().getCells(), JsonNote.class).forEach(_function);
        }
        _xblockexpression = resource;
        return _xblockexpression;
    }

    protected Resource transformRoot(JsonRoot root, @Extension Context context) {
        GMFResource _xblockexpression = null;
        URI _createFileURI = URI.createFileURI((String)"dummy.sct");
        GMFResource resource = new GMFResource(_createFileURI);
        JsonStatechart jsonStatechart = root.getGraph().findStatechart();
        EObject statechart = this.transformElement(jsonStatechart, context);
        EList _contents = resource.getContents();
        _contents.add((Object)statechart);
        Procedures.Procedure1 _function = it -> {
            boolean _containsKey = context.idMap.containsKey(it);
            if (_containsKey) {
                resource.setID(it, context.idMap.get(it));
            }
        };
        IteratorExtensions.forEach((Iterator)resource.getAllContents(), (Procedures.Procedure1)_function);
        _xblockexpression = resource;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonStatechart jsonStatechart, @Extension Context context) {
        boolean _greaterThan;
        Statechart _xblockexpression = null;
        Functions.Function1 _function = it -> !(it instanceof JsonNote);
        Iterable verticesWithoutRegion = IterableExtensions.filter(context.graph.findTopLevelVertices(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)verticesWithoutRegion);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            JsonRegion _jsonRegion = new JsonRegion();
            Procedures.Procedure1 _function_1 = r -> {
                r.setId(EcoreUtil.generateUUID());
                Consumer<JsonCell> _function_2 = it -> it.setParent(r.getId());
                verticesWithoutRegion.forEach(_function_2);
            };
            JsonRegion jsonRegion = (JsonRegion)ObjectExtensions.operator_doubleArrow((Object)_jsonRegion, (Procedures.Procedure1)_function_1);
            context.implicitCells.add(jsonRegion);
            int _indexOf = context.graph.getCells().indexOf(jsonStatechart);
            int _plus = _indexOf + 1;
            context.graph.getCells().add(_plus, jsonRegion);
        }
        Statechart _createStatechart = this._sGraphFactory.createStatechart();
        Procedures.Procedure1 _function_2 = it -> {
            it.setName(jsonStatechart.getName());
            it.setSpecification(jsonStatechart.getSpecification());
            it.setDocumentation(jsonStatechart.getDocumentation());
            EList _regions = it.getRegions();
            Functions.Function1 _function_3 = it_1 -> this.transformElement((JsonCell)it_1, context);
            Iterable _filter = Iterables.filter((Iterable)ListExtensions.map(context.graph.findTopLevelRegions(), (Functions.Function1)_function_3), Region.class);
            Iterables.addAll((Collection)_regions, (Iterable)_filter);
            context.useId((EObject)it, jsonStatechart);
        };
        Statechart statechart = (Statechart)ObjectExtensions.operator_doubleArrow((Object)_createStatechart, (Procedures.Procedure1)_function_2);
        Functions.Function1 _function_3 = it -> it.getSourceId();
        Map transitions = IterableExtensions.groupBy((Iterable)Iterables.filter(context.graph.getCells(), JsonTransition.class), (Functions.Function1)_function_3);
        BiConsumer<String, List> _function_4 = (sourceId, jsonTransitions) -> {
            Functions.Function1 _function_5 = it -> this.priorityAsInt(it.getPriority());
            Consumer<JsonTransition> _function_6 = it -> this.transformElement((JsonCell)it, context);
            IterableExtensions.sortBy((Iterable)jsonTransitions, (Functions.Function1)_function_5).forEach(_function_6);
        };
        transitions.forEach(_function_4);
        _xblockexpression = statechart;
        return _xblockexpression;
    }

    public int priorityAsInt(String it) {
        int _xblockexpression = 0;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
        if (_isNullOrEmpty) {
            return 0;
        }
        int _xtrycatchfinallyexpression = 0;
        try {
            _xtrycatchfinallyexpression = Integer.parseInt(it);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return 0;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonNote jsonState, @Extension Context context) {
        return null;
    }

    protected EObject _transformElement(JsonState jsonState, @Extension Context context) {
        State _xblockexpression = null;
        State _createState = this._sGraphFactory.createState();
        Procedures.Procedure1 _function = it -> {
            it.setName(jsonState.getName());
            it.setSpecification(jsonState.getSpecification());
            it.setDocumentation(jsonState.getDocumentation());
            context.useId((EObject)it, jsonState);
        };
        State state = (State)ObjectExtensions.operator_doubleArrow((Object)_createState, (Procedures.Procedure1)_function);
        Iterable children = Iterables.filter(context.graph.findChildren(jsonState), JsonRegion.class);
        Functions.Function1 _function_1 = child -> this.transformElement((JsonCell)child, context);
        Iterable regions = Iterables.filter((Iterable)IterableExtensions.map((Iterable)children, (Functions.Function1)_function_1), Region.class);
        EList _regions = state.getRegions();
        Iterables.addAll((Collection)_regions, (Iterable)regions);
        _xblockexpression = state;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonRegion jsonRegion, @Extension Context context) {
        Region _xblockexpression = null;
        Region _createRegion = this._sGraphFactory.createRegion();
        Procedures.Procedure1 _function = it -> {
            it.setName(jsonRegion.getName());
            context.useId((EObject)it, jsonRegion);
            this._implicitDefinitions.setImplicit((EObject)it, context.implicitCells.contains(jsonRegion));
        };
        Region region = (Region)ObjectExtensions.operator_doubleArrow((Object)_createRegion, (Procedures.Procedure1)_function);
        Functions.Function1 _function_1 = it -> !(it instanceof JsonTransition);
        Iterable children = IterableExtensions.filter(context.graph.findChildren(jsonRegion), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = child -> this.transformElement((JsonCell)child, context);
        Iterable vertices = Iterables.filter((Iterable)IterableExtensions.map((Iterable)children, (Functions.Function1)_function_2), Vertex.class);
        EList _vertices = region.getVertices();
        Iterables.addAll((Collection)_vertices, (Iterable)vertices);
        _xblockexpression = region;
        return _xblockexpression;
    }

    protected EObject _transformElement(JsonEntry jsonEntry, @Extension Context context) {
        Entry _createEntry = this._sGraphFactory.createEntry();
        Procedures.Procedure1 _function = it -> {
            String _elvis = null;
            JsonNodeLabel _findNodeLabel = context.graph.findNodeLabel(jsonEntry);
            String _name = null;
            if (_findNodeLabel != null) {
                _name = _findNodeLabel.getName();
            }
            _elvis = _name != null ? _name : null;
            it.setName(_elvis);
            it.setKind(EntryKind.getByName((String)StringExtensions.toFirstLower((String)jsonEntry.getEntryKind())));
            context.useId((EObject)it, jsonEntry);
        };
        return (EObject)ObjectExtensions.operator_doubleArrow((Object)_createEntry, (Procedures.Procedure1)_function);
    }

    protected EObject _transformElement(JsonExit jsonExit, @Extension Context context) {
        Exit _createExit = this._sGraphFactory.createExit();
        Procedures.Procedure1 _function = it -> {
            it.setName(context.graph.findNodeLabel(jsonExit).getName());
            context.useId((EObject)it, jsonExit);
        };
        return (EObject)ObjectExtensions.operator_doubleArrow((Object)_createExit, (Procedures.Procedure1)_function);
    }

    protected EObject _transformElement(JsonFinal jsonFinal, @Extension Context context) {
        FinalState _createFinalState = this._sGraphFactory.createFinalState();
        Procedures.Procedure1 _function = it -> {
            it.setName(jsonFinal.getName());
            context.useId((EObject)it, jsonFinal);
        };
        return (EObject)ObjectExtensions.operator_doubleArrow((Object)_createFinalState, (Procedures.Procedure1)_function);
    }

    protected EObject _transformElement(JsonChoice jsonChoice, @Extension Context context) {
        Choice _createChoice = this._sGraphFactory.createChoice();
        Procedures.Procedure1 _function = it -> {
            it.setName(jsonChoice.getName());
            it.setKind(ChoiceKind.DYNAMIC);
            context.useId((EObject)it, jsonChoice);
        };
        return (EObject)ObjectExtensions.operator_doubleArrow((Object)_createChoice, (Procedures.Procedure1)_function);
    }

    protected EObject _transformElement(JsonSynchronization jsonSync, @Extension Context context) {
        Synchronization _createSynchronization = this._sGraphFactory.createSynchronization();
        Procedures.Procedure1 _function = it -> context.useId((EObject)it, jsonSync);
        return (EObject)ObjectExtensions.operator_doubleArrow((Object)_createSynchronization, (Procedures.Procedure1)_function);
    }

    protected EObject _transformElement(JsonTransition jsonTransition, @Extension Context context) {
        Transition _createTransition = this._sGraphFactory.createTransition();
        Procedures.Procedure1 _function = it -> {
            it.setSpecification(jsonTransition.getSpecification());
            it.setDocumentation(jsonTransition.getDocumentation());
            it.setSource(context.vertexMap.get(jsonTransition.getSourceId()));
            it.setTarget(context.vertexMap.get(jsonTransition.getTargetId()));
            context.useId((EObject)it, jsonTransition);
        };
        return (EObject)ObjectExtensions.operator_doubleArrow((Object)_createTransition, (Procedures.Procedure1)_function);
    }

    protected void transformDiagram(Resource resource, @Extension Context context) {
        Statechart statechart = (Statechart)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), Statechart.class));
        if (statechart != null) {
            Diagram _createDiagram = this._notationFactory.createDiagram();
            Procedures.Procedure1 _function = it -> {
                it.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
                it.setType("itemis.create.ui.editor.editor.StatechartDiagramEditor");
                EList _styles = it.getStyles();
                BooleanValueStyle _createBooleanValueStyle = this._notationFactory.createBooleanValueStyle();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setName("inlineDefinitionSection");
                BooleanValueStyle _doubleArrow = (BooleanValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createBooleanValueStyle, (Procedures.Procedure1)_function_1);
                _styles.add((Object)_doubleArrow);
                it.setElement((EObject)statechart);
            };
            Diagram diagram = (Diagram)ObjectExtensions.operator_doubleArrow((Object)_createDiagram, (Procedures.Procedure1)_function);
            EList _contents = resource.getContents();
            _contents.add((Object)diagram);
            this.transformView((NamedElement)statechart, (View)diagram, context);
        }
    }

    protected void _transformView(Statechart statechart, View container, @Extension Context context) {
        Consumer<Region> _function = it -> this.transformView((NamedElement)it, container, context);
        statechart.getRegions().forEach(_function);
        Procedures.Procedure1 _function_1 = it -> this.transformView((NamedElement)it, container, context);
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)statechart.eAllContents(), Transition.class), (Procedures.Procedure1)_function_1);
    }

    protected void _transformView(Region region, View container, @Extension Context context) {
        JsonRegion jsonRegion = context.json((EObject)region, JsonRegion.class);
        Node shape = this._nodeModelFactory.createRegionNode(region);
        Bounds _relativeBounds = this._notationUtil.toRelativeBounds(context.graph, jsonRegion);
        Procedures.Procedure1 _function = it -> {
            it.setWidth(it.getWidth());
            int _height = it.getHeight();
            int _plus = _height + 20;
            it.setHeight(_plus);
        };
        Bounds _doubleArrow = (Bounds)ObjectExtensions.operator_doubleArrow((Object)_relativeBounds, (Procedures.Procedure1)_function);
        shape.setLayoutConstraint((LayoutConstraint)_doubleArrow);
        container.insertChild((View)shape);
        Functions.Function1 _function_1 = it -> {
            String _type = it.getType();
            return Objects.equals(_type, "RegionCompartment");
        };
        View compartmentNode = (View)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)shape.getChildren(), View.class), (Functions.Function1)_function_1);
        EList _styles = shape.getStyles();
        ShapeStyle _createShapeStyle = this._notationFactory.createShapeStyle();
        Procedures.Procedure1 _function_2 = it -> {
            Integer _elvis = null;
            String _fillColor = jsonRegion.getFillColor();
            Integer _shapeColor = null;
            if (_fillColor != null) {
                _shapeColor = this._notationUtil.toShapeColor(_fillColor);
            }
            _elvis = _shapeColor != null ? _shapeColor : Integer.valueOf(0xFAFAFA);
            it.setFillColor(_elvis.intValue());
            Integer _elvis_1 = null;
            String _strokeColor = jsonRegion.getStrokeColor();
            Integer _shapeColor_1 = null;
            if (_strokeColor != null) {
                _shapeColor_1 = this._notationUtil.toShapeColor(_strokeColor);
            }
            _elvis_1 = _shapeColor_1 != null ? _shapeColor_1 : Integer.valueOf(0xC0C0C0);
            it.setLineColor(_elvis_1.intValue());
        };
        ShapeStyle _doubleArrow_1 = (ShapeStyle)ObjectExtensions.operator_doubleArrow((Object)_createShapeStyle, (Procedures.Procedure1)_function_2);
        _styles.add((Object)_doubleArrow_1);
        Consumer<Vertex> _function_3 = v -> this.transformView((NamedElement)v, compartmentNode, context);
        region.getVertices().forEach(_function_3);
    }

    protected void _transformView(State state, View container, @Extension Context context) {
        JsonState jsonState = context.json((EObject)state, JsonState.class);
        Node shape = this._nodeModelFactory.createStateNode(state);
        shape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(context.graph, jsonState));
        context.nodeMap.put(jsonState.getId(), shape);
        container.insertChild((View)shape);
        EList _styles = shape.getStyles();
        BooleanValueStyle _createBooleanValueStyle = this._notationFactory.createBooleanValueStyle();
        Procedures.Procedure1 _function = it -> {
            it.setName("isHorizontal");
            boolean _xifexpression = false;
            _xifexpression = jsonState.getRegionLayout() == null || Objects.equals(jsonState.getRegionLayout(), "horizontal");
            it.setBooleanValue(_xifexpression);
        };
        BooleanValueStyle _doubleArrow = (BooleanValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createBooleanValueStyle, (Procedures.Procedure1)_function);
        _styles.add((Object)_doubleArrow);
        EList _styles_1 = shape.getStyles();
        StringValueStyle _createStringValueStyle = this._notationFactory.createStringValueStyle();
        Procedures.Procedure1 _function_1 = it -> {
            it.setName("featureToShow");
            String _xifexpression = null;
            boolean _showSpecification = jsonState.getShowSpecification();
            _xifexpression = _showSpecification ? "specification" : "documentation";
            it.setStringValue(_xifexpression);
        };
        StringValueStyle _doubleArrow_1 = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle, (Procedures.Procedure1)_function_1);
        _styles_1.add((Object)_doubleArrow_1);
        EList _styles_2 = shape.getStyles();
        ShapeStyle _createShapeStyle = this._notationFactory.createShapeStyle();
        Procedures.Procedure1 _function_2 = it -> {
            Integer _elvis = null;
            String _fillColor = jsonState.getFillColor();
            Integer _shapeColor = null;
            if (_fillColor != null) {
                _shapeColor = this._notationUtil.toShapeColor(_fillColor);
            }
            _elvis = _shapeColor != null ? _shapeColor : Integer.valueOf(15720400);
            it.setFillColor(_elvis.intValue());
            Integer _elvis_1 = null;
            String _strokeColor = jsonState.getStrokeColor();
            Integer _shapeColor_1 = null;
            if (_strokeColor != null) {
                _shapeColor_1 = this._notationUtil.toShapeColor(_strokeColor);
            }
            _elvis_1 = _shapeColor_1 != null ? _shapeColor_1 : Integer.valueOf(0xC0C0C0);
            it.setLineColor(_elvis_1.intValue());
        };
        ShapeStyle _doubleArrow_2 = (ShapeStyle)ObjectExtensions.operator_doubleArrow((Object)_createShapeStyle, (Procedures.Procedure1)_function_2);
        _styles_2.add((Object)_doubleArrow_2);
        Functions.Function1 _function_3 = it -> {
            String _type = it.getType();
            return Objects.equals(_type, "StateFigureCompartment");
        };
        View compartmentNode = (View)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)shape.getChildren(), View.class), (Functions.Function1)_function_3);
        Consumer<Region> _function_4 = it -> this.transformView((NamedElement)it, compartmentNode, context);
        state.getRegions().forEach(_function_4);
    }

    protected void _transformView(Entry entry, View container, @Extension Context context) {
        JsonEntry jsonEntry = context.json((EObject)entry, JsonEntry.class);
        Node entryShape = this._nodeModelFactory.createEntryNode(entry);
        entryShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(context.graph, jsonEntry));
        context.nodeMap.put(jsonEntry.getId(), entryShape);
        container.insertChild((View)entryShape);
    }

    protected void _transformView(Exit exit, View container, @Extension Context context) {
        JsonExit jsonExit = context.json((EObject)exit, JsonExit.class);
        Node exitShape = this._nodeModelFactory.createExitNode(exit);
        exitShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(context.graph, jsonExit));
        context.nodeMap.put(jsonExit.getId(), exitShape);
        container.insertChild((View)exitShape);
    }

    protected void _transformView(FinalState finalState, View container, @Extension Context context) {
        JsonFinal jsonFinal = context.json((EObject)finalState, JsonFinal.class);
        Node finalShape = this._nodeModelFactory.createFinalNode(finalState);
        finalShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(context.graph, jsonFinal));
        context.nodeMap.put(jsonFinal.getId(), finalShape);
        container.insertChild((View)finalShape);
    }

    protected void _transformView(Choice choice, View container, @Extension Context context) {
        JsonChoice jsonChoice = context.json((EObject)choice, JsonChoice.class);
        Node choiceShape = this._nodeModelFactory.createChoiceNode(choice);
        choiceShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(context.graph, jsonChoice));
        context.nodeMap.put(jsonChoice.getId(), choiceShape);
        container.insertChild((View)choiceShape);
    }

    protected void _transformView(Synchronization sync, View container, @Extension Context context) {
        JsonSynchronization jsonSync = context.json((EObject)sync, JsonSynchronization.class);
        context.vertexMap.put(jsonSync.getId(), (Vertex)sync);
        Node syncShape = this._nodeModelFactory.createSynchNode(sync);
        syncShape.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(context.graph, jsonSync));
        context.nodeMap.put(jsonSync.getId(), syncShape);
        container.insertChild((View)syncShape);
    }

    protected void _transformView(Transition transition, View container, @Extension Context context) {
        JsonTransition jsonTransition = context.json((EObject)transition, JsonTransition.class);
        Edge edge = this._nodeModelFactory.createTransitionEdge(transition);
        EList _styles = edge.getStyles();
        StringValueStyle _createStringValueStyle = this._notationFactory.createStringValueStyle();
        Procedures.Procedure1 _function = it -> {
            it.setName("featureToShow");
            String _xifexpression = null;
            boolean _showSpecification = jsonTransition.getShowSpecification();
            _xifexpression = _showSpecification ? "specification" : "documentation";
            it.setStringValue(_xifexpression);
        };
        StringValueStyle _doubleArrow = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle, (Procedures.Procedure1)_function);
        _styles.add((Object)_doubleArrow);
        EList _styles_1 = edge.getStyles();
        ConnectorStyle _createConnectorStyle = this._notationFactory.createConnectorStyle();
        Procedures.Procedure1 _function_1 = it -> {
            boolean _equals;
            Routing _routing = it.getRouting();
            Routing _xifexpression = null;
            JsonTransitionRouter _router = jsonTransition.getRouter();
            String _name = null;
            if (_router != null) {
                _name = _router.getName();
            }
            if (_equals = Objects.equals(_name, "orthogonal")) {
                _xifexpression = Routing.RECTILINEAR_LITERAL;
            } else {
                Object var3_3 = null;
            }
        };
        ConnectorStyle _doubleArrow_1 = (ConnectorStyle)ObjectExtensions.operator_doubleArrow((Object)_createConnectorStyle, (Procedures.Procedure1)_function_1);
        _styles_1.add((Object)_doubleArrow_1);
        edge.setSource((View)context.nodeMap.get(jsonTransition.getSourceId()));
        edge.setTarget((View)context.nodeMap.get(jsonTransition.getTargetId()));
        this.annotateLayoutInfo(jsonTransition, edge);
        DecorationNode _createDecorationNode = this._notationFactory.createDecorationNode();
        Procedures.Procedure1 _function_2 = it -> {
            it.setType("TransitionExpression");
            it.setLayoutConstraint((LayoutConstraint)this._notationUtil.createLabelPosition(jsonTransition));
        };
        DecorationNode _doubleArrow_2 = (DecorationNode)ObjectExtensions.operator_doubleArrow((Object)_createDecorationNode, (Procedures.Procedure1)_function_2);
        edge.insertChild((View)_doubleArrow_2);
        ((Diagram)container).insertEdge(edge);
    }

    public boolean annotateLayoutInfo(JsonTransition transition, Edge edge) {
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals;
        boolean _not;
        boolean _xblockexpression = false;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(transition.getVertices());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.toString();
            String vertices = IterableExtensions.join((Iterable)ListExtensions.map(transition.getVertices(), (Functions.Function1)_function), (CharSequence)",");
            EList _styles = edge.getStyles();
            StringValueStyle _createStringValueStyle = this._notationFactory.createStringValueStyle();
            Procedures.Procedure1 _function_1 = it -> {
                it.setName("joint:vertices");
                it.setStringValue(vertices);
            };
            StringValueStyle _doubleArrow = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle, (Procedures.Procedure1)_function_1);
            _styles.add((Object)_doubleArrow);
        }
        JsonTransitionAnchor source = transition.getSource().getAnchor();
        boolean _and = false;
        Map<String, Object> _args = null;
        if (source != null) {
            _args = source.getArgs();
        }
        Object _get = null;
        if (_args != null) {
            _get = _args.get("dx");
        }
        boolean bl2 = _tripleNotEquals = _get != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1;
            Map<String, Object> _args_1 = null;
            if (source != null) {
                _args_1 = source.getArgs();
            }
            Object _get_1 = null;
            if (_args_1 != null) {
                _get_1 = _args_1.get("dy");
            }
            _and = _tripleNotEquals_1 = _get_1 != null;
        }
        if (_and) {
            EList _styles_1 = edge.getStyles();
            StringValueStyle _createStringValueStyle_1 = this._notationFactory.createStringValueStyle();
            Procedures.Procedure1 _function_2 = it -> {
                it.setName("joint:source:anchor");
                StringConcatenation _builder = new StringConcatenation();
                Object _get_2 = source.getArgs().get("dx");
                _builder.append(_get_2);
                _builder.append(";");
                Object _get_3 = source.getArgs().get("dy");
                _builder.append(_get_3);
                it.setStringValue(_builder.toString());
            };
            StringValueStyle _doubleArrow_1 = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle_1, (Procedures.Procedure1)_function_2);
            _styles_1.add((Object)_doubleArrow_1);
        }
        JsonTransitionAnchor target = transition.getTarget().getAnchor();
        boolean _and_1 = false;
        Map<String, Object> _args_2 = null;
        if (target != null) {
            _args_2 = target.getArgs();
        }
        Object _get_2 = null;
        if (_args_2 != null) {
            _get_2 = _args_2.get("dx");
        }
        boolean bl3 = _tripleNotEquals_2 = _get_2 != null;
        if (!_tripleNotEquals_2) {
            _and_1 = false;
        } else {
            boolean _tripleNotEquals_3;
            Map<String, Object> _args_3 = null;
            if (target != null) {
                _args_3 = target.getArgs();
            }
            Object _get_3 = null;
            if (_args_3 != null) {
                _get_3 = _args_3.get("dy");
            }
            _and_1 = _tripleNotEquals_3 = _get_3 != null;
        }
        if (_and_1) {
            EList _styles_2 = edge.getStyles();
            StringValueStyle _createStringValueStyle_2 = this._notationFactory.createStringValueStyle();
            Procedures.Procedure1 _function_3 = it -> {
                it.setName("joint:target:anchor");
                StringConcatenation _builder = new StringConcatenation();
                Object _get_4 = target.getArgs().get("dx");
                _builder.append(_get_4);
                _builder.append(";");
                Object _get_5 = target.getArgs().get("dy");
                _builder.append(_get_5);
                it.setStringValue(_builder.toString());
            };
            StringValueStyle _doubleArrow_2 = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle_2, (Procedures.Procedure1)_function_3);
            _styles_2.add((Object)_doubleArrow_2);
        }
        boolean _xifexpression = false;
        if (transition.getLabelDistance() != null && transition.getLabelOffset() != null) {
            boolean _xblockexpression_1 = false;
            EList _styles_3 = edge.getStyles();
            StringValueStyle _createStringValueStyle_3 = this._notationFactory.createStringValueStyle();
            Procedures.Procedure1 _function_4 = it -> {
                it.setName("joint:label:distance");
                Double _labelDistance = transition.getLabelDistance();
                String _plus = String.valueOf(_labelDistance);
                it.setStringValue(_plus);
            };
            StringValueStyle _doubleArrow_3 = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle_3, (Procedures.Procedure1)_function_4);
            _styles_3.add((Object)_doubleArrow_3);
            EList _styles_4 = edge.getStyles();
            StringValueStyle _createStringValueStyle_4 = this._notationFactory.createStringValueStyle();
            Procedures.Procedure1 _function_5 = it -> {
                it.setName("joint:label:offset");
                String _labelOffset = transition.getLabelOffset();
                String _plus = _labelOffset;
                it.setStringValue(_plus);
            };
            StringValueStyle _doubleArrow_4 = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle_4, (Procedures.Procedure1)_function_5);
            _xifexpression = _xblockexpression_1 = _styles_4.add((Object)_doubleArrow_4);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean createAnchor(JsonTransitionAnchor anchor, Edge edge) {
        EList _styles = edge.getStyles();
        StringValueStyle _createStringValueStyle = this._notationFactory.createStringValueStyle();
        Procedures.Procedure1 _function = it -> {
            it.setName("jointJsAnchors");
            Object _get = anchor.getArgs().get("dx");
            String _plus = String.valueOf(_get);
            Object _get_1 = anchor.getArgs().get("dy");
            String _plus_1 = _plus + String.valueOf(_get_1);
            it.setStringValue(_plus_1);
        };
        StringValueStyle _doubleArrow = (StringValueStyle)ObjectExtensions.operator_doubleArrow((Object)_createStringValueStyle, (Procedures.Procedure1)_function);
        return _styles.add((Object)_doubleArrow);
    }

    protected void transformNote(JsonNote note, Diagram diagram, @Extension Context context) {
        Shape _createNoteShape = this._nodeModelFactory.createNoteShape();
        Procedures.Procedure1 _function = it -> {
            it.setDescription(note.getName());
            it.setLayoutConstraint((LayoutConstraint)this._notationUtil.toRelativeBounds(context.graph, note));
        };
        Shape _doubleArrow = (Shape)ObjectExtensions.operator_doubleArrow((Object)_createNoteShape, (Procedures.Procedure1)_function);
        diagram.insertChild((View)_doubleArrow);
    }

    @XbaseGenerated
    protected EObject transformElement(JsonCell jsonState, Context context) {
        if (jsonState instanceof JsonNote) {
            return this._transformElement((JsonNote)jsonState, context);
        }
        if (jsonState instanceof JsonState) {
            return this._transformElement((JsonState)jsonState, context);
        }
        if (jsonState instanceof JsonTransition) {
            return this._transformElement((JsonTransition)jsonState, context);
        }
        if (jsonState instanceof JsonChoice) {
            return this._transformElement((JsonChoice)jsonState, context);
        }
        if (jsonState instanceof JsonEntry) {
            return this._transformElement((JsonEntry)jsonState, context);
        }
        if (jsonState instanceof JsonExit) {
            return this._transformElement((JsonExit)jsonState, context);
        }
        if (jsonState instanceof JsonFinal) {
            return this._transformElement((JsonFinal)jsonState, context);
        }
        if (jsonState instanceof JsonRegion) {
            return this._transformElement((JsonRegion)jsonState, context);
        }
        if (jsonState instanceof JsonStatechart) {
            return this._transformElement((JsonStatechart)jsonState, context);
        }
        if (jsonState instanceof JsonSynchronization) {
            return this._transformElement((JsonSynchronization)jsonState, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(jsonState, context).toString());
    }

    @XbaseGenerated
    protected void transformView(NamedElement transition, View container, Context context) {
        if (transition instanceof Transition) {
            this._transformView((Transition)transition, container, context);
            return;
        }
        if (transition instanceof Choice) {
            this._transformView((Choice)transition, container, context);
            return;
        }
        if (transition instanceof Entry) {
            this._transformView((Entry)transition, container, context);
            return;
        }
        if (transition instanceof Exit) {
            this._transformView((Exit)transition, container, context);
            return;
        }
        if (transition instanceof FinalState) {
            this._transformView((FinalState)transition, container, context);
            return;
        }
        if (transition instanceof State) {
            this._transformView((State)transition, container, context);
            return;
        }
        if (transition instanceof Synchronization) {
            this._transformView((Synchronization)transition, container, context);
            return;
        }
        if (transition instanceof Region) {
            this._transformView((Region)transition, container, context);
            return;
        }
        if (transition instanceof Statechart) {
            this._transformView((Statechart)transition, container, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(transition, container, context).toString());
    }

    public static class Context {
        private JsonGraph graph;
        private Map<EObject, String> idMap = new HashMap<EObject, String>();
        private Map<EObject, JsonCell> jsonMap = new HashMap<EObject, JsonCell>();
        private Map<String, Vertex> vertexMap = new HashMap<String, Vertex>();
        private Map<String, Node> nodeMap = new HashMap<String, Node>();
        private Set<JsonCell> implicitCells = new HashSet<JsonCell>();

        protected Vertex useId(EObject it, JsonCell cell) {
            boolean _isNullOrEmpty;
            boolean _not;
            Vertex _xblockexpression = null;
            this.jsonMap.put(it, cell);
            Vertex _xifexpression = null;
            String _id = null;
            if (cell != null) {
                _id = cell.getId();
            }
            boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_id));
            if (_not) {
                Vertex _xblockexpression_1 = null;
                this.idMap.put(it, cell.getId());
                Vertex _xifexpression_1 = null;
                if (it instanceof Vertex) {
                    _xifexpression_1 = this.vertexMap.put(cell.getId(), (Vertex)it);
                }
                _xifexpression = _xblockexpression_1 = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public <T> T json(EObject it, Class<T> clazz) {
            if (it == null) {
                return null;
            }
            JsonCell json = this.jsonMap.get(it);
            if (json != null && clazz.isInstance(json)) {
                return (T)json;
            }
            return null;
        }
    }
}

