/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.json.transformation.model;

import com.google.common.collect.Iterables;
import com.yakindu.sct.json.transformation.model.JsonCell;
import com.yakindu.sct.json.transformation.model.JsonEntry;
import com.yakindu.sct.json.transformation.model.JsonExit;
import com.yakindu.sct.json.transformation.model.JsonNodeLabel;
import com.yakindu.sct.json.transformation.model.JsonRegion;
import com.yakindu.sct.json.transformation.model.JsonStatechart;
import com.yakindu.sct.json.transformation.model.JsonTransition;
import java.util.List;
import java.util.Objects;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
public class JsonGraph {
    private List<JsonCell> cells = CollectionLiterals.newArrayList();

    public List<JsonRegion> findTopLevelRegions() {
        Functions.Function1 _function = it -> StringExtensions.isNullOrEmpty((String)it.getParent());
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(this.cells, JsonRegion.class), (Functions.Function1)_function));
    }

    public List<JsonCell> findTopLevelVertices() {
        Functions.Function1 _function = it -> StringExtensions.isNullOrEmpty((String)it.getParent());
        Functions.Function1 _function_1 = it -> !(it instanceof JsonStatechart);
        Functions.Function1 _function_2 = it -> !(it instanceof JsonRegion);
        Functions.Function1 _function_3 = it -> !(it instanceof JsonTransition);
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(this.cells, JsonCell.class), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
    }

    public List<JsonCell> findChildren(JsonCell parentCell) {
        Functions.Function1 _function = it -> {
            String _parent = it.getParent();
            String _id = parentCell.getId();
            return Objects.equals(_parent, _id);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(this.cells, (Functions.Function1)_function));
    }

    public JsonCell findParent(JsonCell cell) {
        Functions.Function1 _function = it -> {
            String _id = it.getId();
            String _parent = cell.getParent();
            return Objects.equals(_id, _parent);
        };
        return (JsonCell)IterableExtensions.findFirst(this.cells, (Functions.Function1)_function);
    }

    public JsonNodeLabel findNodeLabel(JsonEntry cell) {
        Functions.Function1 _function = it -> {
            String _id = it.getId();
            String _head = (String)IterableExtensions.head(cell.getEmbeds());
            return Objects.equals(_id, _head);
        };
        JsonCell _findFirst = (JsonCell)IterableExtensions.findFirst(this.cells, (Functions.Function1)_function);
        return (JsonNodeLabel)_findFirst;
    }

    public JsonNodeLabel findNodeLabel(JsonExit cell) {
        Functions.Function1 _function = it -> {
            String _id = it.getId();
            String _head = (String)IterableExtensions.head(cell.getEmbeds());
            return Objects.equals(_id, _head);
        };
        JsonCell _findFirst = (JsonCell)IterableExtensions.findFirst(this.cells, (Functions.Function1)_function);
        return (JsonNodeLabel)_findFirst;
    }

    public JsonStatechart findStatechart() {
        return (JsonStatechart)IterableExtensions.head((Iterable)Iterables.filter(this.cells, JsonStatechart.class));
    }

    public List<JsonCell> findContainerHierachy(JsonCell cell, List<JsonCell> container) {
        JsonCell parent = this.findParent(cell);
        if (parent != null) {
            container.add(parent);
            return this.findContainerHierachy(parent, container);
        }
        return container;
    }

    public Iterable<JsonTransition> findOutgoingTransitions(JsonCell cell) {
        Functions.Function1 _function = it -> {
            String _sourceId = it.getSourceId();
            String _id = cell.getId();
            return Objects.equals(_sourceId, _id);
        };
        return IterableExtensions.filter((Iterable)Iterables.filter(this.cells, JsonTransition.class), (Functions.Function1)_function);
    }

    @Pure
    public List<JsonCell> getCells() {
        return this.cells;
    }

    public void setCells(List<JsonCell> cells) {
        this.cells = cells;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("cells", this.cells);
        return b.toString();
    }
}

