/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.artifacts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.itemis.create.base.generator.core.artifacts.IGenArtifact;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

@Singleton
public class DefaultGenArtifactConfigurations
implements IGenArtifactConfigurations {
    private static final String MSG_LOCATION_NOT_FOUND = "Artifact location for {0} not configured";
    @Inject
    private ISCTFileSystemAccess sctFsa;
    protected List<IGenArtifactConfigurations.GenArtifactConfiguration> generationArtifacts = new ArrayList<IGenArtifactConfigurations.GenArtifactConfiguration>();

    @Override
    public List<IGenArtifactConfigurations.GenArtifactConfiguration> getConfigurations() {
        return this.generationArtifacts;
    }

    @Override
    public void configure(String artifactName, String outputConfigName, IGenArtifact artifact) {
        this.configure(artifactName, outputConfigName, artifact, false);
    }

    @Override
    public void configure(String artifactName, String outputConfigName, IGenArtifact artifact, boolean skip) {
        this.generationArtifacts.add(new IGenArtifactConfigurations.GenArtifactConfiguration(artifactName, outputConfigName, artifact, skip));
    }

    protected URI getOutputFolder(String artifactName) {
        for (IGenArtifactConfigurations.GenArtifactConfiguration artifact : this.generationArtifacts) {
            if (!artifact.getName().equals(artifactName)) continue;
            return this.sctFsa.getURI("", artifact.getOutputName());
        }
        return null;
    }

    protected URI getURI(String artifactName) {
        for (IGenArtifactConfigurations.GenArtifactConfiguration artifact : this.generationArtifacts) {
            if (!artifact.getName().equals(artifactName)) continue;
            return this.sctFsa.getURI(artifact.getName(), artifact.getOutputName());
        }
        return null;
    }

    @Override
    public String relativeTo(String target, String fromArtifact) {
        URI baseUri = this.getOutputFolder(fromArtifact);
        if (baseUri == null) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_LOCATION_NOT_FOUND, fromArtifact));
        }
        Path targetPath = new Path(target);
        if (targetPath.isAbsolute()) {
            return this.relativePath(target, this.relative(baseUri));
        }
        URI absUri = this.getURI(target);
        if (absUri != null) {
            return this.relativePath(this.relative(absUri), this.relative(baseUri));
        }
        throw new IllegalArgumentException(MessageFormat.format(MSG_LOCATION_NOT_FOUND, target));
    }

    protected String relative(URI uri) {
        if (uri.isFile()) {
            return uri.toFileString();
        }
        if (uri.isPlatform()) {
            return uri.toPlatformString(true);
        }
        throw new IllegalArgumentException("Unknown URI " + String.valueOf(uri));
    }

    protected String relativePath(String to, String from) {
        Path basePath = new Path(from);
        Path toPath = new Path(to);
        return toPath.makeRelativeTo((IPath)basePath).toString();
    }
}

