/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.execution;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.yakindu.sct.model.sexec.transformation.FlowOptimizer;
import com.yakindu.sct.model.sgen.FeatureConfiguration;
import com.yakindu.sct.model.sgen.GeneratorEntry;

public class FlowOptimizerFactory {
    @Inject
    private Provider<FlowOptimizer> optimizerProvider;

    public FlowOptimizer create(GeneratorEntry entry) {
        FlowOptimizer optimizer = (FlowOptimizer)this.optimizerProvider.get();
        FeatureConfiguration optimizeConfig = entry.getFeatureConfiguration("FunctionInlining");
        optimizer.inlineReactions(this.getBoolValue(optimizeConfig, "inlineReactions", false));
        optimizer.inlineExitActions(this.getBoolValue(optimizeConfig, "inlineExitActions", false));
        optimizer.inlineEntryActions(this.getBoolValue(optimizeConfig, "inlineEntryActions", false));
        optimizer.inlineEnterSequences(this.getBoolValue(optimizeConfig, "inlineEnterSequences", false));
        optimizer.inlineExitSequences(this.getBoolValue(optimizeConfig, "inlineExitSequences", false));
        optimizer.inlineChoices(this.getBoolValue(optimizeConfig, "inlineChoices", true));
        optimizer.inlineEntries(this.getBoolValue(optimizeConfig, "inlineEntries", false));
        optimizer.inlineEnterRegion(this.getBoolValue(optimizeConfig, "inlineEnterRegion", false));
        optimizer.inlineExitRegion(this.getBoolValue(optimizeConfig, "inlineExitRegion", false));
        return optimizer;
    }

    protected boolean getBoolValue(FeatureConfiguration conf, String param, boolean defaultValue) {
        if (conf != null && conf.getParameterValue(param) != null) {
            return conf.getParameterValue(param).getBooleanValue();
        }
        return defaultValue;
    }
}

