/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.execution;

import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.yakindu.sct.domain.extension.BaseModuleProvider;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.domain.extension.IModuleConfigurator;
import com.yakindu.sct.domain.extension.impl.LazyCombiningModule;
import com.yakindu.sct.generator.core.execution.GeneratorEntryModuleConfigurator;
import com.yakindu.sct.generator.core.execution.IGeneratorEntryExecutor;
import com.yakindu.sct.generator.core.extensions.GeneratorExtensions;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgen.GeneratorModel;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class GeneratorExecutorLookup {
    protected Module getContextModule() {
        return new Module(){

            public void configure(Binder binder) {
            }
        };
    }

    public IStatus execute(GeneratorModel model) {
        EList entries = model.getEntries();
        ExecutionStatus executionStatus = new ExecutionStatus();
        for (GeneratorEntry generatorEntry : entries) {
            IGeneratorEntryExecutor executor = this.createExecutor(generatorEntry, model.getGeneratorId());
            IStatus status = executor.execute(generatorEntry);
            executionStatus.merge(status);
        }
        return executionStatus;
    }

    public IGeneratorEntryExecutor createExecutor(GeneratorEntry entry, String generatorId) {
        Optional<IGeneratorDescriptor> description = GeneratorExtensions.getGeneratorDescriptor(generatorId);
        if (!description.isPresent()) {
            throw new RuntimeException("No generator registered for ID: " + generatorId);
        }
        if (entry.getElementRef() == null || entry.getElementRef().eResource() == null) {
            throw new RuntimeException("Could not resolve reference to model ");
        }
        IGeneratorEntryExecutor executor = description.get().createExecutor();
        if (executor == null) {
            throw new RuntimeException("Failed to create generator instance for ID:" + generatorId);
        }
        Injector injector = this.createInjector(entry, description.get(), generatorId);
        injector.injectMembers((Object)executor);
        return executor;
    }

    protected Injector createInjector(GeneratorEntry entry, IGeneratorDescriptor description, String generatorId) {
        Module generatorSpecificModule = description.getBindings(entry);
        Module executionContextModule = this.getContextModule();
        Module domainBaseModule = this.getDomainGeneratorBaseModule(entry, generatorId);
        Module domainOverrideModule = this.getDomainGeneratorModule(entry, generatorId);
        Module combined = Modules.override((Module[])new Module[]{Modules.override((Module[])new Module[]{domainBaseModule}).with(new Module[]{Modules.combine((Module[])new Module[]{generatorSpecificModule, executionContextModule})})}).with(new Module[]{domainOverrideModule});
        return Guice.createInjector((Module[])new Module[]{combined});
    }

    protected Module getDomainGeneratorModule(GeneratorEntry entry, String generatorId) {
        GeneratorEntryModuleConfigurator configurator = new GeneratorEntryModuleConfigurator(entry);
        IDomain domain = DomainRegistry.getDomain((EObject)entry.getElementRef());
        if (domain != null) {
            Module module = domain.getModule("com.yakindu.sct.generator", new String[]{generatorId});
            if (module instanceof LazyCombiningModule) {
                ((LazyCombiningModule)module).applyConfigurator((IModuleConfigurator)configurator);
            }
            return module;
        }
        return new BaseModuleProvider.EmptyModule();
    }

    protected Module getDomainGeneratorBaseModule(GeneratorEntry entry, String generatorId) {
        GeneratorEntryModuleConfigurator configurator = new GeneratorEntryModuleConfigurator(entry);
        IDomain domain = DomainRegistry.getDomain((EObject)entry.getElementRef());
        if (domain != null) {
            Module module = DomainRegistry.getDomain((EObject)entry.getElementRef()).getModule("com.yakindu.sct.generator", new String[]{generatorId, "com.yakindu.sct.base-module"});
            if (module instanceof LazyCombiningModule) {
                ((LazyCombiningModule)module).applyConfigurator((IModuleConfigurator)configurator);
            }
            return module;
        }
        return new BaseModuleProvider.EmptyModule();
    }

    private static class ExecutionStatus
    extends MultiStatus {
        public ExecutionStatus() {
            super("com.yakindu.sct.generator.core", 0, "", null);
        }

        public String getMessage() {
            return String.join((CharSequence)"\n", Iterables.transform(Arrays.asList(this.getChildren()), c -> c.getMessage()));
        }
    }
}

