/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.extensions;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yakindu.sct.generator.core.extensions.ILibraryDescriptor;
import com.yakindu.sct.generator.core.library.IDefaultFeatureValueProvider;
import com.yakindu.sct.generator.core.library.IFeatureTypeLibraryProvider;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class LibraryExtensions {
    private static final String EXTENSION_POINT_ID = "com.yakindu.sct.generator.core.featuretypes";
    private static final String ATTRIBUTE_PROVIDER = "provider";
    private static final String ATTRIBUTE_LIBRARY_ID = "library_id";
    private static final String DEFAULT_PROVIDER = "defaultProvider";
    public static final String GLOBAL_ID = "ALL";
    private static List<ILibraryDescriptor> descriptors;

    public static List<ILibraryDescriptor> getLibraryDescriptors() {
        if (descriptors == null) {
            descriptors = Lists.newArrayList();
            if (Platform.isRunning()) {
                LibraryExtensions.initFromExtensions();
            }
        }
        return descriptors;
    }

    protected static void initFromExtensions() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            descriptors.add(new LibraryDescriptor(iConfigurationElement));
            ++n2;
        }
    }

    public static ILibraryDescriptor getLibraryDescriptor(String libraryId) {
        List<ILibraryDescriptor> libraryDescriptors = LibraryExtensions.getLibraryDescriptors();
        return libraryDescriptors.stream().filter(desc -> desc.getLibraryId().equals(libraryId)).findFirst().get();
    }

    public static IDefaultFeatureValueProvider getDefaultFeatureValueProvider(String libraryId, FeatureTypeLibrary library) {
        ILibraryDescriptor libraryDescriptor = LibraryExtensions.getLibraryDescriptor(libraryId);
        return libraryDescriptor.createFeatureValueProvider();
    }

    private static class LibraryDescriptor
    implements ILibraryDescriptor {
        private final IConfigurationElement configElement;
        private IFeatureTypeLibraryProvider provider;

        LibraryDescriptor(IConfigurationElement configElement) {
            this.configElement = configElement;
        }

        private IFeatureTypeLibraryProvider getFeatureTypeLibraryProvider() {
            if (this.provider == null) {
                try {
                    this.provider = (IFeatureTypeLibraryProvider)this.configElement.createExecutableExtension(LibraryExtensions.ATTRIBUTE_PROVIDER);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return this.provider;
        }

        @Override
        public FeatureTypeLibrary getFeatureTypeLibrary() {
            return this.getFeatureTypeLibraryProvider().get();
        }

        @Override
        public String getLibraryId() {
            return this.configElement.getAttribute(LibraryExtensions.ATTRIBUTE_LIBRARY_ID);
        }

        @Override
        public IDefaultFeatureValueProvider createFeatureValueProvider(Injector injector) {
            try {
                IDefaultFeatureValueProvider provider = (IDefaultFeatureValueProvider)this.configElement.createExecutableExtension(LibraryExtensions.DEFAULT_PROVIDER);
                injector.injectMembers((Object)provider);
                return provider;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public IDefaultFeatureValueProvider createFeatureValueProvider() {
            return this.createFeatureValueProvider(Guice.createInjector((Module[])new Module[0]));
        }
    }
}

