/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.library;

import com.google.inject.Inject;
import com.yakindu.sct.commons.ErrorCodeStatus;
import com.yakindu.sct.generator.core.filesystem.ISCTWorkspaceAccess;
import com.yakindu.sct.generator.core.library.IDefaultFeatureValueProvider;
import com.yakindu.sct.model.sgen.FeatureConfiguration;
import com.yakindu.sct.model.sgen.FeatureParameter;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgen.SGenFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractDefaultFeatureValueProvider
implements IDefaultFeatureValueProvider {
    protected static final SGenFactory factory = SGenFactory.eINSTANCE;
    protected static final String INVALID_IDENTIFIER_REGEX = "[[^a-z]&&[^A-Z]&&[^0-9]]";
    public static final String CODE_MISSING_PROJECT = "error_code_missing_project";
    public static final String REQUIRED_TRUE_PARAMETER = "'%s' must at least define one parameter as 'true'.";
    @Inject
    protected ISCTWorkspaceAccess access;

    @Override
    public final FeatureConfiguration createDefaultFeatureConfiguration(FeatureType type, EObject contextElement) {
        FeatureConfiguration config = this.createConfiguration(type);
        EList parameters = type.getParameters();
        for (FeatureParameter parameter : parameters) {
            FeatureParameterValue parameterValue = this.createParameterValue(type, parameter, contextElement);
            if (parameterValue == null || parameterValue.getExpression() == null) continue;
            config.getParameterValues().add((Object)parameterValue);
        }
        return config;
    }

    protected FeatureParameterValue createParameterValue(FeatureType featureType, FeatureParameter parameter, EObject contextElement) {
        FeatureParameterValue parameterValue = factory.createFeatureParameterValue();
        parameterValue.setParameter(parameter);
        this.setDefaultValue(featureType, parameterValue, contextElement);
        return parameterValue;
    }

    protected FeatureConfiguration createConfiguration(FeatureType type) {
        FeatureConfiguration result = factory.createFeatureConfiguration();
        result.setType(type);
        return result;
    }

    protected String getProjectName(EObject contextElement) {
        URI uri = EcoreUtil.getURI((EObject)this.unwrap(contextElement));
        if (uri.isPlatformResource() && uri.segmentCount() > 1) {
            return URI.decode((String)uri.segment(1));
        }
        return "ProjectName";
    }

    protected EObject unwrap(EObject contextElement) {
        if (contextElement instanceof GeneratorEntry) {
            return ((GeneratorEntry)contextElement).getElementRef();
        }
        return contextElement;
    }

    protected IStatus error(String msg) {
        return new Status(4, "com.yakindu.sct.generator.core", msg);
    }

    protected IStatus error(String msg, String errorCode) {
        return new ErrorCodeStatus(4, "com.yakindu.sct.generator.core", msg, errorCode);
    }

    protected IStatus warning(String msg) {
        return new Status(2, "com.yakindu.sct.generator.core", msg);
    }
}

