/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.library.impl;

import com.google.common.collect.Iterables;
import com.yakindu.sct.generator.core.library.AbstractDefaultFeatureValueProvider;
import com.yakindu.sct.model.sgen.FeatureConfiguration;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class CoreLibraryDefaultFeatureValueProvider
extends AbstractDefaultFeatureValueProvider {
    @Override
    public boolean isProviderFor(FeatureTypeLibrary library) {
        return "Core".equals(library.getName());
    }

    @Override
    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        String parameterName = parameterValue.getParameter().getName();
        if ("targetFolder".equals(parameterName)) {
            parameterValue.setValue("src-gen");
        } else if ("libraryTargetFolder".equals(parameterName)) {
            parameterValue.setValue("src");
        } else if ("targetProject".equals(parameterName)) {
            parameterValue.setValue(this.getProjectName(contextElement));
        } else if ("licenseText".equals(parameterName)) {
            parameterValue.setValue("Enter license text here");
        } else if ("dumpSexec".equals(parameterName)) {
            parameterValue.setValue(false);
        } else if ("debugExecution".equals(parameterName)) {
            parameterValue.setValue(false);
        } else if ("observables".equals(parameterName)) {
            parameterValue.setValue(true);
        } else if ("getters".equals(parameterName)) {
            parameterValue.setValue(false);
        } else if ("inlineChoices".equals(parameterName)) {
            parameterValue.setValue(true);
        }
    }

    @Override
    public IStatus validateParameterValue(FeatureParameterValue parameterValue) {
        String parameterName = parameterValue.getParameter().getName();
        if ("targetProject".equals(parameterName) && !this.access.projectExists(parameterValue.getStringValue())) {
            return this.error(String.format("The Project %s does not exist.", parameterValue.getStringValue()), "error_code_missing_project");
        }
        if ("targetProject".equals(parameterName) && this.access.projectExists(parameterValue.getStringValue()) && !this.access.projectOpened(parameterValue.getStringValue())) {
            return this.error(String.format("The Project %s is not open.", parameterValue.getStringValue()));
        }
        if ("targetFolder".equals(parameterName) || "libraryTargetFolder".equals(parameterName) || "apiTargetFolder".equals(parameterName)) {
            String targetProjectName;
            FeatureParameterValue targetProjectParam = parameterValue.getFeatureConfiguration().getParameterValue("targetProject");
            String string = targetProjectName = targetProjectParam != null ? targetProjectParam.getStringValue() : null;
            if (targetProjectName != null && !this.access.folderExists(targetProjectName, parameterValue.getStringValue())) {
                return this.warning(String.format("The Folder %s does not exist in Project %s", parameterValue.getStringValue(), targetProjectName));
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateConfiguration(FeatureConfiguration configuration) {
        String featureName = configuration.getType().getName();
        if ("OutEventAPI".equals(featureName)) {
            return this.validateOutEventApi(configuration);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateOutEventApi(FeatureConfiguration configuration) {
        FeatureParameterValue observablesValue = configuration.getParameterValue("observables");
        if (observablesValue == null || observablesValue.getBooleanValue()) {
            return Status.OK_STATUS;
        }
        Iterable trueValues = Iterables.filter((Iterable)configuration.getParameterValues(), p -> p.getBooleanValue());
        if (trueValues.iterator().hasNext()) {
            return Status.OK_STATUS;
        }
        return this.error(String.format("'%s' must at least define one parameter as 'true'.", configuration.getType().getName()));
    }
}

