/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.domain.c.runtime.fileextensions.CDomainFileExtensions;
import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource;
import com.yakindu.sct.domain.c.runtime.resource.CHeaderToPackageImportVisitor;
import com.yakindu.sct.domain.c.runtime.resource.IncludePathImport;
import com.yakindu.sct.model.stext.scoping.AbstractPackageImportUriMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.xtext.util.IResourceScopeCache;

@Singleton
public class CHeaderIncludeUriMapper
extends AbstractPackageImportUriMapper {
    @Inject
    protected IResourceScopeCache externalImportCache;
    @Inject
    protected Provider<CHeaderToPackageImportVisitor> visitorProvider;

    public Set<IPackageImport2URIMapper.PackageImport> getAllImports(Resource context) {
        LinkedHashSet<IPackageImport2URIMapper.PackageImport> result = new LinkedHashSet<IPackageImport2URIMapper.PackageImport>();
        result.addAll(this.getProjectPackageImports(this.getContextResource(context)));
        result.addAll(this.getCDTIncludePathsPackageImports(this.getContextResource(context)));
        return result;
    }

    public boolean canHandle(Resource context, String packageImport) {
        List<String> cppFileExtensions = CDomainFileExtensions.CPP_FILE_EXTENSIONS;
        for (String string : cppFileExtensions) {
            if (!packageImport.endsWith("." + string)) continue;
            return true;
        }
        return false;
    }

    public Optional<IPackageImport2URIMapper.PackageImport> findPackageImport(Resource context, String packageImport) {
        Set<IPackageImport2URIMapper.PackageImport> allImports = this.getCDTIncludePathsPackageImports(this.getContextResource(context));
        for (IPackageImport2URIMapper.PackageImport current : allImports) {
            if (!current.getName().equals(packageImport)) continue;
            return Optional.of(current);
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.getContextResource(context));
        if (file == null) {
            return Optional.empty();
        }
        IPath importPath = file.getFullPath().removeLastSegments(1).append(packageImport);
        IFile wsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(importPath);
        if (wsFile.exists() && CDomainFileExtensions.isRelevantImport(wsFile.getName(), wsFile.getProject().getName())) {
            URI importURI = ((CHeaderToPackageImportVisitor)this.visitorProvider.get()).createEnvironmentAwareImportURI((IResource)wsFile);
            String importNamespace = CHeaderResource.computePackageName(wsFile);
            return Optional.of(new IPackageImport2URIMapper.PackageImport(packageImport, importURI, importNamespace));
        }
        return Optional.empty();
    }

    protected Set<IPackageImport2URIMapper.PackageImport> getProjectPackageImports(Resource context) {
        IProject project = this.getProject(this.getContextResource(context));
        if (!project.exists()) {
            return Sets.newHashSet();
        }
        LinkedHashSet<IPackageImport2URIMapper.PackageImport> packageImports = new LinkedHashSet<IPackageImport2URIMapper.PackageImport>();
        CHeaderToPackageImportVisitor visitor = (CHeaderToPackageImportVisitor)this.visitorProvider.get();
        visitor.initialize(this.getContextResource(context), packageImports);
        try {
            for (IResource sourceFolder : this.getSourceFolders(project)) {
                sourceFolder.accept((IResourceVisitor)visitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return packageImports;
    }

    protected List<IResource> getSourceFolders(IProject project) throws CModelException {
        ICProject cProject = CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(project.getName());
        ISourceRoot[] allSourceRoots = cProject.getAllSourceRoots();
        ArrayList sourceFolders = Lists.newArrayList();
        ISourceRoot[] iSourceRootArray = allSourceRoots;
        int n = allSourceRoots.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceRoot sourceRoot = iSourceRootArray[n2];
            if (sourceRoot.getResource() != null) {
                sourceFolders.add(sourceRoot.getResource());
            }
            ++n2;
        }
        return sourceFolders;
    }

    protected Set<IPackageImport2URIMapper.PackageImport> getCDTIncludePathsPackageImports(final Resource context) {
        return (Set)this.externalImportCache.get(CHeaderIncludeUriMapper.class, this.getContextResource(context), (Provider)new Provider<Set<IPackageImport2URIMapper.PackageImport>>(){

            public Set<IPackageImport2URIMapper.PackageImport> get() {
                LinkedHashSet<IPackageImport2URIMapper.PackageImport> files = new LinkedHashSet<IPackageImport2URIMapper.PackageImport>();
                List<String> systemIncludePathes = CHeaderIncludeUriMapper.this.getExternalIncludePathes(CHeaderIncludeUriMapper.this.getProject(CHeaderIncludeUriMapper.this.getContextResource(context)));
                for (String directory : systemIncludePathes) {
                    CHeaderIncludeUriMapper.this.collectExternalImports(CHeaderIncludeUriMapper.this.getContextProjectName(CHeaderIncludeUriMapper.this.getContextResource(context)), directory, directory, files);
                }
                return files;
            }
        });
    }

    protected String getContextProjectName(Resource context) {
        return WorkspaceSynchronizer.getFile((Resource)this.getContextResource(context)).getProject().getName();
    }

    protected List<String> getExternalIncludePathes(IProject project) {
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null) {
            return this.getIncludePaths(project, provider);
        }
        return Lists.newArrayList();
    }

    protected List<String> getIncludePaths(IProject project, IScannerInfoProvider provider) {
        ArrayList includePathes = Lists.newArrayList();
        IScannerInfo scanInfo = provider.getScannerInformation((IResource)project);
        if (scanInfo != null) {
            String[] includePaths;
            String[] stringArray = includePaths = scanInfo.getIncludePaths();
            int n = includePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                includePathes.add(string);
                ++n2;
            }
        }
        return includePathes;
    }

    protected void collectExternalImports(String project, String directory, String contextPath, Set<IPackageImport2URIMapper.PackageImport> headerFiles) {
        File[] faFiles = new File(directory).listFiles();
        if (faFiles == null) {
            return;
        }
        File[] fileArray = faFiles;
        int n = faFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String absoluteFilePath = file.getAbsolutePath();
            if (file.isDirectory()) {
                this.collectExternalImports(project, absoluteFilePath, contextPath, headerFiles);
            } else if (CDomainFileExtensions.isRelevantImport(file.getName(), project)) {
                String importLiteral = Path.fromOSString((String)absoluteFilePath).makeRelativeTo(Path.fromOSString((String)contextPath)).toPortableString();
                Path path = new Path(file.getAbsolutePath());
                IFile fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                if (fileForLocation != null && fileForLocation.exists()) {
                    headerFiles.add(this.createWorkspaceInclude(project, file, fileForLocation, importLiteral));
                } else {
                    headerFiles.add(this.createSystemInclude(project, file, importLiteral));
                }
            }
            ++n2;
        }
    }

    protected IncludePathImport createSystemInclude(String project, File importFile, String importLiteral) {
        return new IncludePathImport(importLiteral, URI.createFileURI((String)importFile.getAbsolutePath()).appendQuery(project), Files.getNameWithoutExtension((String)importFile.getName()));
    }

    protected IncludePathImport createWorkspaceInclude(String project, File file, IFile fileForLocation, String importLiteral) {
        URI importURI = this.createEnvironmentAwareImportURI(project, file, fileForLocation);
        return new IncludePathImport(importLiteral, importURI, CHeaderResource.computePackageName(fileForLocation));
    }

    protected URI createEnvironmentAwareImportURI(String project, File file, IFile fileForLocation) {
        return URI.createPlatformResourceURI((String)fileForLocation.getFullPath().toString(), (boolean)true);
    }

    protected IProject getProject(Resource context) {
        return WorkspaceSynchronizer.getFile((Resource)this.getContextResource(context)).getProject();
    }
}

