/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.validator;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.types.ArrayTypeSpecifier;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypedElement;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.c.runtime.resource.transform.c.CTypeUtils;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CBuiltInTypesValidator
extends AbstractDeclarativeValidator {
    public static final String ARRAY_DIMENSIONS_OUT_OF_BOUNDS = "Array type has %s dimensions, not %s.";
    public static final String ARRAY_ACCESS_NOT_SUPPORTED_WITH_SMART_PTR = "Array access is not supported on smart pointers.";
    @Inject
    protected ITypeSystem ts;
    @Inject
    @Extension
    protected CTypeUtils _cTypeUtils;

    protected void _checkArrayAccesForSmartPointer(Expression e) {
    }

    protected boolean _isArrayAcces(EObject it) {
        return false;
    }

    protected boolean _isArrayAcces(ElementReferenceExpression it) {
        return it.isArrayAccess();
    }

    protected boolean _isArrayAcces(FeatureCall it) {
        return it.isArrayAccess();
    }

    @Check
    protected void _checkArrayAccesForSmartPointer(ElementReferenceExpression e) {
        EObject _reference_1;
        TypeSpecifier typeSpec;
        boolean _isSmartPointerType;
        boolean _and = false;
        boolean _or = false;
        boolean _isArrayAccess = e.isArrayAccess();
        if (_isArrayAccess) {
            _or = true;
        } else {
            EObject _eContainer = e.eContainer();
            boolean _isArrayAcces = false;
            if (_eContainer != null) {
                _isArrayAcces = this.isArrayAcces(_eContainer);
            }
            _or = _isArrayAcces;
        }
        if (!_or) {
            _and = false;
        } else {
            EObject _reference = e.getReference();
            _and = _reference instanceof TypedElement;
        }
        if (_and && (_isSmartPointerType = this._cTypeUtils.isSmartPointerType((typeSpec = this.getArrayTypeSpecifier((TypedElement)(_reference_1 = e.getReference()))).getType()))) {
            this.error(String.format(ARRAY_ACCESS_NOT_SUPPORTED_WITH_SMART_PTR, new Object[0]), (EObject)e, null);
        }
    }

    @Check
    protected void _checkArrayAccesForSmartPointer(FeatureCall e) {
        if (e.isArrayAccess() && e.getFeature() instanceof TypedElement) {
            EObject _feature;
            TypeSpecifier typeSpec;
            boolean _isSmartPointerType;
            boolean _isValueOnPointer = this._cTypeUtils.isValueOnPointer(e);
            if (_isValueOnPointer) {
                this.checkArrayAccesForSmartPointer(e.getOwner());
            }
            if (_isSmartPointerType = this._cTypeUtils.isSmartPointerType((typeSpec = this.getArrayTypeSpecifier((TypedElement)(_feature = e.getFeature()))).getType())) {
                this.error(String.format(ARRAY_ACCESS_NOT_SUPPORTED_WITH_SMART_PTR, new Object[0]), (EObject)e, null);
            }
        }
    }

    @Check
    public void checkArrayDimension(ElementReferenceExpression e) {
        if (e.isArrayAccess() && e.getReference() instanceof TypedElement) {
            boolean _greaterThan;
            EObject _reference = e.getReference();
            TypeSpecifier typeSpec = this.getArrayTypeSpecifier((TypedElement)_reference);
            int _xifexpression = 0;
            _xifexpression = typeSpec != null ? this.getArrayDimensions(typeSpec) : 0;
            int arrayDims = _xifexpression;
            int _size = e.getArraySelector().size();
            boolean bl = _greaterThan = _size > arrayDims;
            if (_greaterThan) {
                this.error(String.format(ARRAY_DIMENSIONS_OUT_OF_BOUNDS, arrayDims, e.getArraySelector().size()), (EObject)e, null);
            }
        }
    }

    @Check
    public void checkArrayDimension(FeatureCall e) {
        if (e.isArrayAccess() && e.getFeature() instanceof TypedElement) {
            boolean _greaterThan;
            EObject _feature = e.getFeature();
            TypeSpecifier typeSpec = this.getArrayTypeSpecifier((TypedElement)_feature);
            int _xifexpression = 0;
            _xifexpression = typeSpec != null ? this.getArrayDimensions(typeSpec) : 0;
            int arrayDims = _xifexpression;
            int _size = e.getArraySelector().size();
            boolean bl = _greaterThan = _size > arrayDims;
            if (_greaterThan) {
                this.error(String.format(ARRAY_DIMENSIONS_OUT_OF_BOUNDS, arrayDims, e.getArraySelector().size()), (EObject)e, null);
            }
        }
    }

    protected int getArrayDimensions(TypeSpecifier typeSpecifier) {
        boolean _isPointerType = this._cTypeUtils.isPointerType(typeSpecifier.getType());
        if (_isPointerType) {
            return 1;
        }
        boolean _isArrayType = this._cTypeUtils.isArrayType(typeSpecifier.getType());
        if (_isArrayType) {
            int _arrayDimensions = this.getArrayDimensions((TypeSpecifier)typeSpecifier.getTypeArguments().get(0));
            return 1 + _arrayDimensions;
        }
        return 0;
    }

    protected TypeSpecifier getArrayTypeSpecifier(TypedElement element) {
        TypeSpecifier _typeSpecifier = element.getTypeSpecifier();
        if (_typeSpecifier instanceof ArrayTypeSpecifier) {
            TypeSpecifier _typeSpecifier_1 = element.getTypeSpecifier();
            return (ArrayTypeSpecifier)_typeSpecifier_1;
        }
        TypeSpecifier typeSpec = element.getTypeSpecifier();
        Type _type = typeSpec.getType();
        if (_type instanceof TypedElement) {
            Type _type_1 = typeSpec.getType();
            return this.getArrayTypeSpecifier((TypedElement)_type_1);
        }
        return typeSpec;
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }

    @XbaseGenerated
    public void checkArrayAccesForSmartPointer(Expression e) {
        if (e instanceof ElementReferenceExpression) {
            this._checkArrayAccesForSmartPointer((ElementReferenceExpression)e);
            return;
        }
        if (e instanceof FeatureCall) {
            this._checkArrayAccesForSmartPointer((FeatureCall)e);
            return;
        }
        if (e != null) {
            this._checkArrayAccesForSmartPointer(e);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    @XbaseGenerated
    public boolean isArrayAcces(EObject it) {
        if (it instanceof ElementReferenceExpression) {
            return this._isArrayAcces((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._isArrayAcces((FeatureCall)it);
        }
        if (it != null) {
            return this._isArrayAcces(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

