/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.resource;

import com.google.inject.Inject;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.sct.domain.java.resource.trafo.JavaToTypesTransformation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaResource
extends ResourceImpl {
    public static final String DOMAIN_ID = "com.yakindu.domain.java";
    @Inject
    private JavaToTypesTransformation trafo;
    private String project;

    public void load(Map<?, ?> options) throws IOException {
        if (this.uri.hasQuery()) {
            try {
                this.uri = this.getURI().trimQuery();
                super.load(options);
            }
            finally {
                this.uri = this.getURI().appendQuery(this.getContextProject());
            }
        } else {
            super.load(options);
        }
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.trafo.setURI(this.getURI());
        try {
            if (this.uri.isPlatformResource()) {
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.uri.toPlatformString(true)));
                Assert.isTrue((boolean)iResource.exists());
                if (iResource.getProject().getNature("org.eclipse.jdt.core.javanature") == null) {
                    return;
                }
                this.project = iResource.getProject().getName();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.uri.toPlatformString(true)));
                IJavaElement javaElement = JavaCore.create((IFile)file);
                if (javaElement instanceof ICompilationUnit) {
                    IType[] types;
                    ICompilationUnit cu = (ICompilationUnit)javaElement;
                    String packageName = this.getPackageName(cu);
                    Package rootPackage = this.createPackage(packageName);
                    IType[] iTypeArray = types = cu.getTypes();
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType iType = iTypeArray[n2];
                        this.trafo.createType((Declaration)rootPackage, iType, (IAdaptable)cu);
                        ++n2;
                    }
                    this.getContents().add((Object)rootPackage);
                }
            } else if (this.uri.isArchive() || "jrt".equals(this.uri.scheme())) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
                IJavaProject java = JavaCore.create((IProject)project);
                IType iType = java.findType(this.classNameFromUri(this.uri));
                Package rootPackage = this.createPackage(this.getPackageName(iType));
                this.trafo.createType((Declaration)rootPackage, iType, (IAdaptable)iType);
                this.getContents().add((Object)rootPackage);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected String classNameFromUri(URI uri) {
        ArrayList segments = new ArrayList(uri.segmentsList());
        if ("jrt".equals(uri.scheme())) {
            if ("modules".equals(uri.segment(0))) {
                segments.remove(0);
            }
            segments.remove(0);
        }
        return String.join((CharSequence)".", segments).replaceFirst("\\.class", "");
    }

    protected String getPackageName(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit.getPackageDeclarations().length > 0) {
            return compilationUnit.getPackageDeclarations()[0].getElementName();
        }
        return "";
    }

    protected String getPackageName(IType type) {
        return Signature.getQualifier((String)type.getFullyQualifiedName());
    }

    protected Package createPackage(String name) {
        Package result = TypesFactory.eINSTANCE.createPackage();
        result.setDomainID(DOMAIN_ID);
        result.setName(name);
        return result;
    }

    public void setContextProject(String query) {
        this.project = query;
    }

    public String getContextProject() {
        return this.project;
    }
}

