/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.typesystem;

import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.GenericTypeValueProvider;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.java.resource.JavaResource;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class JavaTypeValueProvider
extends GenericTypeValueProvider {
    @Inject
    private ITypeSystem typeSystem;

    public Object defaultValue(Type type) {
        if (this.is(type = type.getOriginType(), "boolean")) {
            return Boolean.FALSE;
        }
        if (this.is(type, "byte")) {
            return (byte)0;
        }
        if (this.is(type, "char")) {
            return Character.valueOf('\u0000');
        }
        if (this.is(type, "double")) {
            return 0.0;
        }
        if (this.is(type, "float")) {
            return Float.valueOf(0.0f);
        }
        if (this.is(type, "int")) {
            return 0;
        }
        if (this.is(type, "long")) {
            return 0L;
        }
        if (this.is(type, "short")) {
            return (short)0;
        }
        if (this.is(type, "string")) {
            return new String();
        }
        if (type instanceof EnumerationType) {
            EList enums = ((EnumerationType)type).getEnumerator();
            if (enums.size() > 0) {
                return enums.get(0);
            }
            return null;
        }
        if (type instanceof ComplexType && type.eResource() instanceof JavaResource) {
            return null;
        }
        List superTypes = this.typeSystem.getSuperTypes(type);
        if (!superTypes.isEmpty()) {
            return this.defaultValue((Type)superTypes.get(0));
        }
        return super.defaultValue(type);
    }
}

