/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.yakindu.base.types.AnnotationType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.libraries.ITypeLibraryProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeLibraryScope
extends AbstractScope {
    protected ITypeLibraryProvider libraryProvider;
    protected Set<URI> importedURIs;

    public TypeLibraryScope(IScope outer, ITypeLibraryProvider context, Set<URI> importedLibs) {
        super(outer, false);
        this.libraryProvider = context;
        this.importedURIs = importedLibs;
        if (this.importedURIs == null) {
            this.importedURIs = Collections.unmodifiableSet(CollectionLiterals.newHashSet());
        }
    }

    protected Iterable<Declaration> getImportedDeclarations() {
        Iterable _xblockexpression = null;
        Functions.Function1 _function = it -> this.importedURIs.contains(it.getLibraryURI());
        Functions.Function1 _function_1 = it -> it.getLibraryPackage();
        List importedLibraries = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.libraryProvider.provide(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IteratorExtensions.toList((Iterator)it.eAllContents()), Declaration.class));
        _xblockexpression = Iterables.concat((Iterable)ListExtensions.map((List)importedLibraries, (Functions.Function1)_function_2));
        return _xblockexpression;
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return Scopes.scopedElementsFor(this.getImportedDeclarations());
    }

    public static class AnnotationTypeScope
    extends TypeLibraryScope {
        public AnnotationTypeScope(IScope outer, ITypeLibraryProvider context, Set<URI> importedLibs) {
            super(outer, context, importedLibs);
        }

        @Override
        protected Iterable<IEObjectDescription> getAllLocalElements() {
            return Scopes.scopedElementsFor((Iterable)Iterables.filter(this.getImportedDeclarations(), AnnotationType.class));
        }
    }

    public static class TypeScope
    extends TypeLibraryScope {
        protected EClass type;

        public TypeScope(IScope outer, ITypeLibraryProvider context, Set<URI> importedLibs) {
            this(outer, context, importedLibs, EcorePackage.Literals.EOBJECT);
        }

        public TypeScope(IScope outer, ITypeLibraryProvider context, Set<URI> importedLibs, EClass type) {
            super(outer, context, importedLibs);
            this.type = type;
            if (this.type == null) {
                this.type = EcorePackage.Literals.EOBJECT;
            }
        }

        @Override
        protected Iterable<IEObjectDescription> getAllLocalElements() {
            Iterable _xblockexpression = null;
            Iterable importedTypes = Iterables.filter(this.getImportedDeclarations(), Type.class);
            Iterable _scopedElementsFor = Scopes.scopedElementsFor((Iterable)importedTypes);
            Function _function = e -> TypesUtil.toQualifiedName(e);
            Functions.Function1 _function_1 = it -> this.type.isSuperTypeOf(it.getEClass());
            Iterable _filter = IterableExtensions.filter((Iterable)Scopes.scopedElementsFor((Iterable)importedTypes, (Function)_function), (Functions.Function1)_function_1);
            _xblockexpression = Iterables.concat((Iterable)_scopedElementsFor, (Iterable)_filter);
            return _xblockexpression;
        }
    }
}

