/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.typesystem;

import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.typesystem.ITypeValueProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class GenericTypeValueProvider
implements ITypeValueProvider {
    protected Map<Type, Type> defaultSuperTypeMap = new HashMap<Type, Type>();
    @Inject
    protected ITypeSystem typeSystem;

    @Override
    public Object defaultValue(Type type) {
        List<Type> superTypes;
        if (this.is(type = type.getOriginType(), "void")) {
            return null;
        }
        if (this.is(type, "integer")) {
            return 0L;
        }
        if (this.is(type, "real")) {
            return 0.0;
        }
        if (this.is(type, "boolean")) {
            return Boolean.FALSE;
        }
        if (this.is(type, "string")) {
            return new String("");
        }
        if (type instanceof EnumerationType) {
            EList<Enumerator> enums = ((EnumerationType)type).getEnumerator();
            if (enums.size() > 0) {
                return enums.get(0);
            }
            return null;
        }
        if (type instanceof ComplexType) {
            return null;
        }
        Type defaultSuperType = this.defaultSuperTypeMap.get(type);
        if (defaultSuperType == null && !(superTypes = this.typeSystem.getSuperTypes(type)).isEmpty()) {
            defaultSuperType = superTypes.get(0);
            this.defaultSuperTypeMap.put(type, defaultSuperType);
        }
        if (defaultSuperType != null) {
            return this.defaultValue(defaultSuperType);
        }
        if (type instanceof TypeParameter) {
            return null;
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(type));
    }

    protected boolean is(Type type, String typeName) {
        return this.typeSystem.isSame(type, this.typeSystem.getType(typeName));
    }
}

