/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.typesystem;

import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public interface ITypeSystem {
    public static final String STRING = "string";
    public static final String STRING_LITERAL = "string:literal";
    public static final String REAL = "real";
    public static final String INTEGER = "integer";
    public static final String UNSIGNED_INTEGER = "unsigned integer";
    public static final String BOOLEAN = "boolean";
    public static final String VOID = "void";
    public static final String NULL = "null";
    public static final String ANY = "any";
    public static final String ARRAY = "array";
    public static final String MAP = "map";
    public static final String FUNCTION = "function";
    public static final String UNDEFINED = "__undefined__";

    public Collection<Type> getTypes();

    public Collection<Type> getConcreteTypes();

    public Type getType(String var1);

    public boolean isSame(Type var1, Type var2);

    public boolean haveCommonType(Type var1, Type var2);

    public Type getCommonType(Type var1, Type var2);

    public boolean haveCommonTypeWithConversion(Type var1, Type var2);

    public Type getCommonTypeWithConversion(Type var1, Type var2);

    public List<Type> getSuperTypes(Type var1);

    public boolean isSuperType(Type var1, Type var2);

    public List<Operation> getOperationExtensions(Type var1);

    public List<Property> getPropertyExtensions(Type var1);

    public List<Declaration> getMetaFeatures(Class<? extends Declaration> var1);

    public List<Declaration> getMetaFeatures(Declaration var1);

    public boolean isExtensionOperation(Operation var1);

    public boolean isExtensionProperty(Property var1);

    public boolean isMetaFeature(Declaration var1);

    public boolean isConvertableTo(Type var1, Type var2);

    public boolean isString(Type var1);

    public boolean isStringLiteral(Type var1);

    public boolean isReal(Type var1);

    public boolean isInteger(Type var1);

    public boolean isBoolean(Type var1);

    public boolean isVoid(Type var1);

    public boolean isAny(Type var1);

    public boolean isArray(Type var1);

    public boolean isMap(Type var1);

    public boolean isFunction(Type var1);

    public boolean isUndefined(Type var1);

    public Resource getResource();
}

