/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.util;

import com.yakindu.base.types.Argument;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.TypesPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ArgumentSorter {
    public static EList<Expression> getOrderedExpressions(List<Argument> arguments, Operation operation) {
        return ArgumentSorter.getOrderedExpressions(arguments, operation.getParameters());
    }

    public static EList<Expression> getOrderedExpressions(List<Argument> arguments, List<? extends Declaration> parameters) {
        List<ArgumentOrder> argumentOrders = ArgumentSorter.getArgumentOrders(arguments, parameters);
        int argumentCount = arguments.size() >= parameters.size() ? arguments.size() : parameters.size();
        Expression[] result = new Expression[argumentCount];
        argumentOrders.stream().forEachOrdered(o -> {
            if (o.isValid() && (!o.isNamed() || result[o.getOrder()] == null)) {
                expressionArray[o.getOrder()] = o.getArgument().getValue();
            }
        });
        BasicEList resultAsList = new BasicEList();
        int i = 0;
        while (i < result.length) {
            Expression expression = result[i];
            if (expression != null) {
                resultAsList.add((Object)expression);
            }
            ++i;
        }
        return resultAsList;
    }

    public static List<ArgumentOrder> getArgumentOrders(List<Argument> arguments, List<? extends Declaration> parameters) {
        List parameterNames = parameters.stream().map(p -> p.getName()).collect(Collectors.toList());
        ArrayList<ArgumentOrder> orders = new ArrayList<ArgumentOrder>();
        int i = 0;
        while (i < arguments.size()) {
            Argument a = arguments.get(i);
            String name = ArgumentSorter.getArgumentName(a);
            int order = i;
            if (name != null && !name.isBlank()) {
                order = parameterNames.indexOf(name);
            } else {
                name = null;
            }
            orders.add(new ArgumentOrder(a, name, order));
            ++i;
        }
        return orders;
    }

    private static String getArgumentName(Argument argument) {
        if (argument.eGet((EStructuralFeature)TypesPackage.Literals.ARGUMENT__PARAMETER, false) != null && !((EObject)argument.eGet((EStructuralFeature)TypesPackage.Literals.ARGUMENT__PARAMETER, false)).eIsProxy()) {
            if (argument.getParameter().getName() != null && !argument.getParameter().getName().isBlank()) {
                return argument.getParameter().getName();
            }
        } else {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)argument, (EStructuralFeature)TypesPackage.Literals.ARGUMENT__PARAMETER);
            if (!nodes.isEmpty() && ((INode)nodes.get(0)).getText() != null && !((INode)nodes.get(0)).getText().isBlank()) {
                return ((INode)nodes.get(0)).getText();
            }
        }
        return null;
    }

    public static class ArgumentOrder {
        public static final int INVALID_ORDER = -1;
        private Argument argument;
        private String name;
        private int order;

        public ArgumentOrder(Argument argument, String name, int order) {
            this.argument = argument;
            this.name = name;
            this.order = order;
        }

        public Argument getArgument() {
            return this.argument;
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isValid() {
            return this.order != -1;
        }

        public boolean isNamed() {
            return this.name != null && !this.name.isBlank();
        }
    }
}

