/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.model.presenter;

import com.google.common.collect.Lists;
import com.yakindu.base.gmf.runtime.highlighting.IHighlightingSupport;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.ui.model.presenter.DefaultDynamicNotationHandler;
import com.yakindu.sct.simulation.ui.model.presenter.IDynamicNotationHandler;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sct.ui.editor.partitioning.SubmachineEditorInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SCTSourceDisplay
implements ISourceDisplay,
IDebugEventSetListener,
IPartListener {
    private Map<IEditorInput, IDynamicNotationHandler> handler = new HashMap<IEditorInput, IDynamicNotationHandler>();
    private ILaunch activeLaunch;

    public synchronized void displaySource(Object element, IWorkbenchPage page, boolean forceSourceLookup) {
        IDebugTarget debugTarget = this.unwrapTarget(element);
        if (debugTarget == null || this.getDiagram(debugTarget) == null) {
            return;
        }
        this.setActiveLaunch(debugTarget);
        IEditorPart editorPart = this.openEditor(debugTarget, page);
        IDynamicNotationHandler notationHandler = this.getHandler(editorPart);
        notationHandler.display((ExecutionContext)debugTarget.getAdapter(ExecutionContext.class));
        this.restoreActiveEditors();
    }

    protected void setActiveLaunch(IDebugTarget debugTarget) {
        ILaunch currentLaunch = debugTarget.getLaunch();
        if (this.activeLaunch != currentLaunch) {
            for (IDynamicNotationHandler current : this.handler.values()) {
                current.terminate();
            }
            this.handler.clear();
            this.activeLaunch = currentLaunch;
        }
    }

    protected void restoreActiveEditors() {
        List<DiagramEditor> editors = this.getAllOpenSubmachineEditors();
        for (DiagramEditor diagramEditor : editors) {
            Optional<ExecutionContext> contextOptional = this.findExecutionContext(diagramEditor);
            if (!contextOptional.isPresent()) continue;
            IDynamicNotationHandler notationHandler = this.getHandler((IEditorPart)diagramEditor);
            notationHandler.display(contextOptional.get());
        }
    }

    protected Optional<ExecutionContext> findExecutionContext(DiagramEditor editor) {
        IDebugTarget[] debugTargets;
        IDebugTarget[] iDebugTargetArray = debugTargets = this.activeLaunch.getDebugTargets();
        int n = debugTargets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget debugTarget = iDebugTargetArray[n2];
            ExecutionContext context = (ExecutionContext)debugTarget.getAdapter(ExecutionContext.class);
            Diagram diagram = this.getDiagram(debugTarget);
            if (context.getContextFqn() != null && new SubmachineEditorInput(diagram, context.getContextFqn()).equals((Object)editor.getEditorInput())) {
                return Optional.of(context);
            }
            ++n2;
        }
        return Optional.empty();
    }

    protected Diagram getDiagram(IDebugTarget debugTarget) {
        EObject semanticObject = (EObject)debugTarget.getAdapter(EObject.class);
        Diagram diagram = DiagramPartitioningUtil.getDiagramContaining((EObject)semanticObject);
        if (diagram == null) {
            return null;
        }
        if (URIConverter.INSTANCE.exists(EcoreUtil.getURI((EObject)diagram), null)) {
            return (Diagram)DiagramPartitioningUtil.getSharedDomain().getResourceSet().getEObject(EcoreUtil.getURI((EObject)diagram), true);
        }
        return null;
    }

    protected List<DiagramEditor> getAllOpenSubmachineEditors() {
        IEditorReference[] editorReferences;
        ArrayList result = Lists.newArrayList();
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput editorInput;
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            IEditorPart editor = iEditorReference.getEditor(false);
            if (editor instanceof DiagramEditor && (editorInput = editor.getEditorInput()) instanceof SubmachineEditorInput) {
                result.add((DiagramEditor)editor);
            }
            ++n2;
        }
        return result;
    }

    protected IDynamicNotationHandler getHandler(IEditorPart editorPart) {
        IDynamicNotationHandler notationHandler = this.handler.get(editorPart.getEditorInput());
        if (notationHandler == null) {
            notationHandler = new DefaultDynamicNotationHandler();
            IHighlightingSupport support = (IHighlightingSupport)editorPart.getAdapter(IHighlightingSupport.class);
            if (support != null) {
                notationHandler.setHighlightingSupport(support);
            }
            if (support.isLocked()) {
                support.releaseAndLockEditor();
            } else {
                support.lockEditor();
            }
            this.handler.put(editorPart.getEditorInput(), notationHandler);
        }
        return notationHandler;
    }

    protected IDebugTarget unwrapTarget(Object element) {
        if (element instanceof ILaunch) {
            return ((ILaunch)element).getDebugTarget();
        }
        if (element instanceof PlatformObject) {
            return (IDebugTarget)((PlatformObject)element).getAdapter(IDebugTarget.class);
        }
        return null;
    }

    protected IEditorPart openEditor(IDebugTarget debugTarget, IWorkbenchPage page) {
        ExecutionContext context = (ExecutionContext)debugTarget.getAdapter(ExecutionContext.class);
        Diagram diagram = this.getDiagram(debugTarget);
        if (context != null && context.getContextFqn() != null) {
            return DiagramPartitioningUtil.openSubmachineEditor((Diagram)diagram, (String)context.getContextFqn());
        }
        return DiagramPartitioningUtil.openEditor((Diagram)diagram);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8) {
                this.handleDebugTargetTerminated(event);
            }
            ++n2;
        }
    }

    protected void handleDebugTargetTerminated(DebugEvent debugEvent) {
        Object source = debugEvent.getSource();
        if (source instanceof IDebugTarget) {
            this.terminateDynamicNotationForDebugTarget((IDebugTarget)source);
        }
    }

    public void terminateDynamicNotationForDebugTarget(IDebugTarget target) {
        if (this.activeLaunch == target.getLaunch()) {
            this.activeLaunch = null;
            for (IDynamicNotationHandler current : this.handler.values()) {
                current.getHighlightingSupport().releaseEditor();
                current.terminate();
            }
            this.handler.clear();
        }
    }

    public void partOpened(IWorkbenchPart part) {
        this.highlightState(part);
    }

    public void partActivated(IWorkbenchPart part) {
        this.highlightState(part);
    }

    protected void highlightState(IWorkbenchPart part) {
        IEditorInput editorInput;
        if (this.activeLaunch == null) {
            return;
        }
        if (part instanceof DiagramEditor && !((editorInput = ((DiagramEditor)part).getEditorInput()) instanceof SubmachineEditorInput)) {
            IDynamicNotationHandler notationHandler = this.getHandler((IEditorPart)part);
            notationHandler.display((ExecutionContext)this.activeLaunch.getDebugTarget().getAdapter(ExecutionContext.class));
        }
    }

    public void partClosed(IWorkbenchPart part) {
        IEditorInput input;
        IDynamicNotationHandler notationHandler;
        if (part instanceof DiagramEditor && (notationHandler = this.handler.get(input = ((DiagramEditor)part).getEditorInput())) != null) {
            notationHandler.terminate();
            this.handler.remove(input);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }
}

