/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view;

import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractDebugTargetView
extends ViewPart
implements IDebugEventSetListener,
ILaunchListener {
    protected IDebugTarget debugTarget;

    protected abstract void activeTargetChanged(IDebugTarget var1);

    protected abstract void handleDebugEvent(DebugEvent var1);

    public AbstractDebugTargetView() {
        this.registerListeners();
    }

    protected void registerListeners() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        super.dispose();
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            PlatformObject object = (PlatformObject)((IStructuredSelection)event.getContext()).getFirstElement();
            if (object == null) {
                return;
            }
            IDebugTarget newTarget = null;
            newTarget = object instanceof Launch ? ((Launch)object).getDebugTarget() : (IDebugTarget)object.getAdapter(IDebugTarget.class);
            this.changeTarget(newTarget);
        }
    }

    protected void changeTarget(IDebugTarget newTarget) {
        if (newTarget == this.debugTarget) {
            return;
        }
        if (newTarget != this.debugTarget && newTarget != null && !newTarget.isTerminated()) {
            this.debugTarget = newTarget;
            this.activeTargetChanged(newTarget);
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
        IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget newTarget = iDebugTargetArray[n2];
            if (newTarget instanceof SCTDebugTarget && ((SCTDebugTarget)newTarget).isPrimary()) {
                this.changeTarget(newTarget);
            }
            ++n2;
        }
    }

    public final void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent debugEvent = debugEventArray[n2];
            if (debugEvent.getSource() instanceof SCTDebugTarget && debugEvent.getSource() == this.debugTarget) {
                this.handleDebugEvent(debugEvent);
            }
            ++n2;
        }
    }
}

