/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view;

import com.google.common.collect.Maps;
import com.yakindu.base.expressions.interpreter.base.InterpreterSession;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.adapter.OriginTracing;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionOperation;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import com.yakindu.sct.simulation.ui.SimulationImages;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class ExecutionContextLabelProvider
extends StyledCellLabelProvider {
    private final int index;
    private static Map<String, Button> viewerCells = Maps.newHashMap();
    private boolean isReadOnly;
    private OriginTracing trace = new OriginTracing();

    public ExecutionContextLabelProvider(int index, boolean isReadOnly) {
        this.index = index;
        this.isReadOnly = isReadOnly;
    }

    public void update(ViewerCell cell) {
        switch (this.index) {
            case 0: {
                this.updateNameCell(cell);
                break;
            }
            case 1: {
                this.updateValueCell(cell);
            }
        }
        super.update(cell);
    }

    private void updateValueCell(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof ReferenceSlot) {
            ReferenceSlot refSlot = (ReferenceSlot)element;
            Object label = "";
            if (refSlot.getReference() != null) {
                Object refValue;
                int lastDot;
                String refFqn;
                String refName = refFqn = refSlot.getReference().getFqName();
                String refNamespace = null;
                int n = lastDot = refFqn != null ? refFqn.lastIndexOf(46) : -1;
                if (lastDot != -1) {
                    refName = refFqn.substring(lastDot + 1);
                    refNamespace = refFqn.substring(0, lastDot);
                }
                label = (String)((refValue = refSlot.getReference().getValue()) != null ? refName + " = " + String.valueOf(refValue) : refName) + (String)(refNamespace != null ? " (from " + refNamespace + ")" : "");
            } else {
                label = "null";
            }
            cell.setText((String)label);
        } else if (element instanceof CompositeSlot) {
            cell.setText("");
        } else if (element instanceof ExecutionSlot) {
            ExecutionSlot slot = (ExecutionSlot)element;
            Object value = slot.getValue();
            if (value != null) {
                if (this.needsCheckbox(slot)) {
                    TreeItem currentItem = (TreeItem)cell.getItem();
                    NativeCellWidgetUtil.addNativeCheckbox(cell, slot, value, new TreeEditorDisposeListener(currentItem));
                } else {
                    cell.setText(this.getCellTextValue(slot, value));
                }
            } else {
                cell.setText("");
            }
        }
    }

    protected boolean needsCheckbox(ExecutionSlot slot) {
        if (slot.isWritable() && !this.isReadOnly && this.isPrimitiveType(slot)) {
            return this.isBooleanType(slot.getValue(), (PrimitiveType)slot.getType().getOriginType());
        }
        return false;
    }

    protected String getCellTextValue(Object element, Object value) {
        if (this.isEnumType(element)) {
            return this.getEnumName(element, value);
        }
        return value.toString();
    }

    protected boolean isBooleanType(Object value, PrimitiveType primitiveType) {
        return primitiveType != null && value instanceof Boolean;
    }

    protected boolean isPrimitiveType(Object element) {
        Type type = ((ExecutionSlot)element).getType();
        return type != null && type.getOriginType() instanceof PrimitiveType;
    }

    protected String getEnumName(Object element, Object value) {
        if (value instanceof Enumerator) {
            return ((Enumerator)value).getName();
        }
        return "";
    }

    protected boolean isEnumType(Object element) {
        Type type = ((ExecutionSlot)element).getType();
        return type != null && type.getOriginType() instanceof EnumerationType;
    }

    private void updateNameCell(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof ExecutionEvent) {
            ExecutionEvent event = (ExecutionEvent)element;
            cell.setText(event.getName());
            StyleRange style1 = new StyleRange();
            style1.start = 0;
            style1.length = event.getName().length();
            style1.underline = true;
            style1.foreground = ColorConstants.lightBlue;
            cell.setText(event.getName());
            cell.setStyleRanges(new StyleRange[]{style1});
            if (event.isRaised()) {
                cell.setImage(SimulationImages.EVENT_ENABLED.image());
            } else if (event.getName().contains("time_event")) {
                cell.setImage(SimulationImages.TIMEEVENT.image());
            } else {
                cell.setImage(SimulationImages.EVENT_DISABLED.image());
            }
        } else if (element instanceof ExecutionOperation) {
            ExecutionVariable variable = (ExecutionVariable)element;
            cell.setText(variable.getName());
            cell.setImage(SimulationImages.OPERATION.image());
        } else if (element instanceof ExecutionVariable) {
            ExecutionVariable variable = (ExecutionVariable)element;
            cell.setText(variable.getName());
            if (((ExecutionVariable)element).isWritable()) {
                cell.setImage(SimulationImages.VARIABLE.image());
            } else {
                cell.setImage(SimulationImages.VARIABLE_LOCK.image());
            }
        } else if (element instanceof ExecutionContext) {
            cell.setText(((CompositeSlot)element).getName());
            cell.setImage(SimulationImages.SUB_STATECHART_PICTOGRAM.image());
        } else if (element instanceof ReferenceSlot) {
            cell.setText(((ReferenceSlot)element).getName());
            cell.setImage(SimulationImages.REFERENCE.image());
        } else if (element instanceof CompositeSlot) {
            CompositeSlot slot = (CompositeSlot)element;
            cell.setText(slot.getName());
            if (this.trace.origin((EObject)slot) instanceof Package) {
                cell.setImage(SimulationImages.PACKAGE.image());
            } else if ("#jobs".equals(slot.getName())) {
                cell.setText("jobs");
                cell.setImage(SimulationImages.OPERATION.image());
            } else if ("#globals".equals(slot.getName())) {
                cell.setText("packages");
                cell.setImage(SimulationImages.PACKAGE.image());
            } else {
                cell.setImage(SimulationImages.SCOPE.image());
            }
        }
    }

    protected static class NativeCellWidgetUtil {
        protected static Cursor handCursor = null;

        protected NativeCellWidgetUtil() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected static Cursor provideHandCursor() {
            if (handCursor != null) return handCursor;
            Class<NativeCellWidgetUtil> clazz = NativeCellWidgetUtil.class;
            synchronized (NativeCellWidgetUtil.class) {
                if (handCursor != null) return handCursor;
                handCursor = new Cursor((Device)Display.getDefault(), 21);
                // ** MonitorExit[var0] (shouldn't be in output)
                return handCursor;
            }
        }

        protected static void addNativeCheckbox(ViewerCell cell, Object element, Object value, TreeEditorDisposeListener listener) {
            TreeItem currentItem = (TreeItem)cell.getItem();
            ExecutionSlot execSlot = (ExecutionSlot)element;
            String cellKey = execSlot.getFqName();
            if (viewerCells.get(cellKey) == null || viewerCells.get(cellKey).isDisposed() || viewerCells.get(cellKey).getSelection() != ((Boolean)value).booleanValue()) {
                NativeCellWidgetUtil.manageEditorDisposal(currentItem, listener);
                TreeEditor editor = NativeCellWidgetUtil.createEditor(currentItem);
                Composite comp = NativeCellWidgetUtil.createEditorComposite(currentItem);
                Button button = NativeCellWidgetUtil.createNativeCheckboxCellWidget(element, comp);
                editor.setEditor((Control)comp, currentItem, cell.getColumnIndex());
                viewerCells.put(cellKey, button);
            }
        }

        protected static Button createNativeCheckboxCellWidget(final Object element, Composite comp) {
            Button button = new Button(comp, 32);
            button.setCursor(NativeCellWidgetUtil.provideHandCursor());
            button.setLayoutData((Object)new GridData(1, 4, false, true));
            final Label label = new Label(comp, 1);
            label.setCursor(NativeCellWidgetUtil.provideHandCursor());
            label.setForeground(ColorConstants.gray);
            label.setText(((ExecutionSlot)element).getValue().toString());
            label.setLayoutData((Object)new GridData(4, 4, true, false));
            label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    NativeCellWidgetUtil.changeLabelText(element, label);
                }
            });
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NativeCellWidgetUtil.changeLabelText(element, label);
                }
            });
            NativeCellWidgetUtil.restoreSelection(((ExecutionSlot)element).getValue(), button);
            return button;
        }

        protected static void changeLabelText(Object element, Label label) {
            Boolean currentValue = (Boolean)((ExecutionSlot)element).getValue();
            InterpreterSession session = InterpreterSession.SessionAdapter.session((EObject)((ExecutionSlot)element));
            if (session != null) {
                session.setValue((Object)((ExecutionSlot)element), (Object)(currentValue == false ? 1 : 0));
            } else {
                ((ExecutionSlot)element).setValue((Object)(currentValue == false ? 1 : 0));
            }
            label.setText(Boolean.toString(currentValue == false));
        }

        protected static Composite createEditorComposite(TreeItem currentItem) {
            Composite comp = new Composite((Composite)currentItem.getParent(), 1);
            comp.setBackground(currentItem.getBackground());
            comp.setBackgroundMode(1);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 3;
            comp.setLayout((Layout)layout);
            return comp;
        }

        protected static TreeEditor createEditor(TreeItem currentItem) {
            TreeEditor editor = new TreeEditor(currentItem.getParent());
            editor.grabVertical = true;
            editor.grabHorizontal = true;
            currentItem.setData("EDITOR", (Object)editor);
            return editor;
        }

        protected static void manageEditorDisposal(TreeItem currentItem, TreeEditorDisposeListener listener) {
            listener.disposeTreeEditor();
            listener.removeDisposeListener();
            currentItem.addDisposeListener((DisposeListener)listener);
            currentItem.setData("DISPOSELISTENER", (Object)listener);
        }

        protected static void restoreSelection(Object value, Button button) {
            if (((Boolean)value).booleanValue() != button.getSelection()) {
                button.setSelection(((Boolean)value).booleanValue());
            }
        }
    }

    protected class TreeEditorDisposeListener
    implements DisposeListener {
        private static final String LISTENER_DATA = "DISPOSELISTENER";
        private static final String EDITOR_DATA = "EDITOR";
        private final TreeItem currentItem;

        protected TreeEditorDisposeListener(TreeItem currentItem) {
            this.currentItem = currentItem;
        }

        public void widgetDisposed(DisposeEvent e) {
            this.disposeTreeEditor();
        }

        protected void disposeTreeEditor() {
            if (this.currentItem.getData(EDITOR_DATA) != null) {
                TreeEditor editor = (TreeEditor)this.currentItem.getData(EDITOR_DATA);
                editor.getEditor().dispose();
                editor.dispose();
            }
        }

        protected void removeDisposeListener() {
            if (this.currentItem.getData(LISTENER_DATA) != null) {
                this.currentItem.removeDisposeListener((DisposeListener)this.currentItem.getData(LISTENER_DATA));
            }
        }
    }
}

