/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.commands;

import com.yakindu.base.base.BasePackage;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.commands.AbstractActionRun;
import com.yakindu.sct.ui.editor.commands.DocOrExprAction;
import com.yakindu.sct.ui.editor.commands.DocumentationDropDownAction;
import com.yakindu.sct.ui.editor.commands.ToggleShowDocumentationCommand;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.EcoreUtil2;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public class DocumentationMenuAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private List<Action> actions;
    public static final String ID = "com.yakindu.sct.ui.editor.commands.toggleDocumentation";

    public DocumentationMenuAction() {
        super("Toggle Documentation", 4);
        this.setId(ID);
        this.setMenuCreator(this);
        this.setImageDescriptor(StatechartImages.MENU.imageDescriptor());
        this.actions = new ArrayList<Action>();
        this.createActions();
    }

    private void createActions() {
        AbstractActionRun action = new DocumentationDropDownAction("Show expressions", SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION.getName());
        action.setImageDescriptor(StatechartImages.EXPR.imageDescriptor());
        this.actions.add(action);
        action = new DocumentationDropDownAction("Show documentation", BasePackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION.getName());
        action.setImageDescriptor(StatechartImages.DOCU.imageDescriptor());
        this.actions.add(action);
        action = new DocOrExprAction("Show documentation if present");
        action.setImageDescriptor(StatechartImages.EXPR.imageDescriptor());
        this.actions.add(action);
    }

    public void run() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof StatechartDiagramEditor) {
            Diagram diagram = ((StatechartDiagramEditor)activeEditor).getDiagram();
            List result = EcoreUtil2.getAllContentsOfType((EObject)diagram, View.class);
            ToggleShowDocumentationCommand.toggleDocumentation(result);
        }
    }

    public void dispose() {
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        for (IAction iAction : this.actions) {
            this.addActionToMenu(this.fMenu, iAction);
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }
}

