/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.editor;

import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public class SCTFileEditorOpener
implements IURIEditorOpener {
    public IEditorPart open(URI uri, boolean select) {
        try {
            IFile fileToOpen = this.toFile(uri);
            if (fileToOpen != null) {
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(fileToOpen), this.getEditorID());
                if (uri.fragment() == null || uri.fragment().isEmpty()) {
                    return editor;
                }
                if (editor instanceof DiagramEditor) {
                    DiagramEditor diagramEditor = (DiagramEditor)editor;
                    EObject targetElement = diagramEditor.getDiagram().eResource().getEObject(uri.fragment());
                    if (targetElement == null) {
                        return editor;
                    }
                    View view = DiagramPartitioningUtil.findNotationView(targetElement);
                    if (view == null) {
                        return editor;
                    }
                    Diagram element = DiagramPartitioningUtil.getDiagramContaining(view.getElement());
                    diagramEditor = (DiagramEditor)DiagramPartitioningUtil.openEditor(element);
                    Map editPartRegistry = diagramEditor.getDiagramGraphicalViewer().getEditPartRegistry();
                    EditPart targetEditPart = (EditPart)editPartRegistry.get(view);
                    if (targetEditPart != null) {
                        DiagramPartitioningUtil.selectElementsInDiagram((IDiagramWorkbenchPart)diagramEditor, Arrays.asList(targetEditPart));
                    }
                    return diagramEditor;
                }
                return editor;
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getEditorID() {
        return "org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor";
    }

    public IEditorPart open(URI referenceOwnerURI, EReference reference, int indexInList, boolean select) {
        return this.open(referenceOwnerURI, select);
    }

    public IFile toFile(URI uri) {
        if (uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        }
        return null;
    }
}

