/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.editparts;

import com.google.inject.Injector;
import com.yakindu.base.gmf.runtime.parsers.StringAttributeParser;
import com.yakindu.base.xtext.utils.gmf.directedit.IEAttributeProvider;
import com.yakindu.base.xtext.utils.gmf.directedit.IXtextAwareEditPart;
import com.yakindu.base.xtext.utils.gmf.directedit.StyleRanges;
import com.yakindu.base.xtext.utils.gmf.directedit.XtextDirectEditManager;
import com.yakindu.base.xtext.utils.gmf.directedit.XtextLabelEditPart;
import com.yakindu.base.xtext.utils.gmf.figures.SyntaxColoringLabel;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.SpecificationElement;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.policies.EAttributeDirectEditPolicy;
import com.yakindu.sct.ui.editor.utils.FontScalingUtil;
import java.util.List;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.FontData;

public abstract class PlugableXtextLabelEditPart
extends XtextLabelEditPart
implements ITextAwareEditPart,
IEAttributeProvider,
IPropertyChangeListener,
ZoomListener {
    private static final String PRIMARY_VIEW_LISTENER = "primaryViewListener";
    private Injector injector;

    protected abstract int getEditorStyles();

    public PlugableXtextLabelEditPart(View view, String target) {
        super(view);
        this.init(target);
    }

    public void activate() {
        super.activate();
        DiagramActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getZoomManager().addZoomListener((ZoomListener)this);
    }

    protected ZoomManager getZoomManager() {
        return ((DiagramRootEditPart)this.getRoot()).getZoomManager();
    }

    public void deactivate() {
        super.deactivate();
        DiagramActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.getZoomManager().removeZoomListener((ZoomListener)this);
    }

    protected SyntaxColoringLabel createFigure() {
        SyntaxColoringLabel label = super.createFigure();
        label.setHighlight(DiagramActivator.getDefault().getPreferenceStore().getBoolean("Appearance.diagram.syntaxcoloring"));
        label.setZoom(this.getZoomManager().getZoom());
        return label;
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter(PRIMARY_VIEW_LISTENER, (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        this.removeListenerFilter(PRIMARY_VIEW_LISTENER);
        super.removeNotationalListeners();
    }

    protected void init(String target) {
        IDomain domain = DomainRegistry.getDomain((EObject)this.resolveSemanticElement());
        if (domain != null) {
            this.injector = domain.getInjector("com.yakindu.sct.editor", new String[]{target});
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new EAttributeDirectEditPolicy(this));
    }

    protected DirectEditManager createDirectEditManager() {
        if (this.injector != null) {
            return new XtextDirectEditManager((IXtextAwareEditPart)this, this.injector, this.getEditorStyles());
        }
        return new TextDirectEditManager((ITextAwareEditPart)this);
    }

    protected void setLabelStyles(String text) {
        StyleRanges styleRanges = (StyleRanges)this.injector.getInstance(StyleRanges.class);
        List result = styleRanges.getRanges(text);
        this.getFigure().setRanges(result.toArray(new StyleRange[0]));
    }

    public SpecificationElement resolveSemanticElement() {
        return (SpecificationElement)super.resolveSemanticElement();
    }

    public Injector getInjector() {
        return this.injector;
    }

    public String getEditText() {
        String exp = (String)this.resolveSemanticElement().eGet((EStructuralFeature)this.getAttribute());
        return exp != null ? exp : "";
    }

    public ICellEditorValidator getEditTextValidator() {
        return null;
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        return new StringAttributeParser((IEAttributeProvider)this, "com.yakindu.sct.ui.editor");
    }

    public IContentAssistProcessor getCompletionProcessor() {
        return null;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getFeature() == this.getAttribute() || notification.getFeature() == NotationPackage.Literals.STRING_VALUE_STYLE__STRING_VALUE) {
            this.refreshVisuals();
        }
        super.handleNotificationEvent(notification);
    }

    protected void refreshVisuals() {
        this.updateLabelText();
        this.setLabelStyles(this.getEditText());
        super.refreshVisuals();
    }

    protected void updateLabelText() {
        String label = (String)this.resolveSemanticElement().eGet((EStructuralFeature)this.getAttribute());
        if (label != null && label.equals(this.getFigure().getText())) {
            return;
        }
        this.getFigure().setText(label);
    }

    protected void setContext(Resource resource) {
        resource.eAdapters().add((Object)new ContextElementAdapter((EObject)this.resolveSemanticElement()));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("Appearance.diagram.syntaxcoloring".equals(event.getProperty())) {
            this.getFigure().setHighlight(((Boolean)event.getNewValue()).booleanValue());
            this.setLabelStyles(this.getEditText());
            this.getFigure().invalidateTree();
            this.getFigure().revalidate();
        } else if ("Appearance.diagram.fontscaling".equals(event.getProperty())) {
            this.refreshVisuals();
        }
    }

    public void zoomChanged(double zoom) {
        this.getFigure().setZoom(zoom);
        this.getFigure().invalidateTree();
        this.getFigure().revalidate();
    }

    protected void setFont(FontData fontData) {
        super.setFont(FontScalingUtil.scaleFont(fontData));
    }
}

