/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.policies;

import com.yakindu.base.gmf.runtime.editpolicies.SetPreferredSizeRequest;
import com.yakindu.sct.ui.editor.editparts.RegionEditPart;
import com.yakindu.sct.ui.editor.editparts.StateEditPart;
import com.yakindu.sct.ui.editor.policies.FixedBendpointEditPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;

public class EnlargeContainerEditPolicy
extends AbstractEditPolicy {
    public static final Object ROLE = "ResizeContainer";
    private Map<IFigure, PrecisionRectangle> boundsCache = new HashMap<IFigure, PrecisionRectangle>();
    private List<IGraphicalEditPart> containerHierachy;
    public static final int SPACEING = 20;

    public Command getCommand(Request request) {
        if (!"resize".equals(request.getType()) && !"move".equals(request.getType())) {
            return null;
        }
        if (request instanceof SetPreferredSizeRequest) {
            this.showSourceFeedback(request);
        }
        ChangeBoundsRequest cbr = (ChangeBoundsRequest)request;
        CompoundCommand result = new CompoundCommand();
        if (this.containerHierachy != null) {
            for (IGraphicalEditPart currentContainer : this.containerHierachy) {
                IFigure figure = currentContainer.getFigure();
                SetBoundsCommand boundsCommand = new SetBoundsCommand(this.getHost().getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)currentContainer.getNotationView()), figure.getBounds());
                result.add((Command)new ICommandProxy((ICommand)boundsCommand));
                FixedBendpointEditPolicy editPolicy = (FixedBendpointEditPolicy)currentContainer.getEditPolicy((Object)"Fixed_Bendpoints");
                if (editPolicy != null) {
                    Command command = editPolicy.getCommand((Request)cbr);
                    result.add(command);
                }
                List children = currentContainer.getParent().getChildren();
                for (IGraphicalEditPart childPart : children) {
                    if (cbr.getEditParts().contains(childPart)) continue;
                    IFigure childFigure = childPart.getFigure();
                    if (childPart == currentContainer) continue;
                    SetBoundsCommand childBoundsCommand = new SetBoundsCommand(this.getHost().getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)childPart.getNotationView()), childFigure.getBounds());
                    result.add((Command)new ICommandProxy((ICommand)childBoundsCommand));
                }
            }
        }
        return result;
    }

    public IGraphicalEditPart getHost() {
        return (IGraphicalEditPart)super.getHost();
    }

    public void showSourceFeedback(Request request) {
        if (this.containerHierachy == null) {
            this.containerHierachy = this.collectContainerHierachy();
        }
        if (!"resize".equals(request.getType()) && !"move".equals(request.getType())) {
            return;
        }
        this.showContainerFeedback((ChangeBoundsRequest)request);
    }

    public void eraseSourceFeedback(Request request) {
        this.boundsCache.clear();
        for (IGraphicalEditPart iGraphicalEditPart : this.containerHierachy) {
            EditPolicy editPolicy = iGraphicalEditPart.getEditPolicy((Object)"Fixed_Bendpoints");
            if (editPolicy == null) continue;
            editPolicy.eraseSourceFeedback(request);
        }
        this.containerHierachy = null;
        super.eraseSourceFeedback(request);
    }

    protected void showContainerFeedback(ChangeBoundsRequest request) {
        for (IGraphicalEditPart containerEditPart : this.containerHierachy) {
            IFigure containerFigure = containerEditPart.getFigure();
            Rectangle feedbackBounds = this.getOriginalBounds(containerFigure);
            containerFigure.getParent().translateToAbsolute((Translatable)feedbackBounds);
            feedbackBounds = this.calculateFeedbackBounds(request, feedbackBounds, containerFigure);
            containerFigure.translateToRelative((Translatable)feedbackBounds);
            this.setBounds(containerFigure, feedbackBounds);
            EditPolicy editPolicy = containerEditPart.getEditPolicy((Object)"Fixed_Bendpoints");
            if (editPolicy == null) continue;
            editPolicy.showSourceFeedback((Request)request);
        }
    }

    protected List<IGraphicalEditPart> collectContainerHierachy() {
        ArrayList<IGraphicalEditPart> result = new ArrayList<IGraphicalEditPart>();
        IGraphicalEditPart containerEditPart = this.getHost();
        while (containerEditPart != null) {
            if ((containerEditPart = this.getContainer(containerEditPart)) == null) continue;
            result.add(containerEditPart);
        }
        return result;
    }

    private Rectangle getOriginalBounds(IFigure figure) {
        Rectangle originalContainerBounds = (Rectangle)this.boundsCache.get(figure);
        if (originalContainerBounds == null) {
            originalContainerBounds = figure.getBounds().getCopy();
            this.boundsCache.put(figure, new PrecisionRectangle(originalContainerBounds));
        }
        return this.boundsCache.get(figure).getCopy();
    }

    private IGraphicalEditPart getContainer(IGraphicalEditPart host) {
        IGraphicalEditPart containerEditPart = this.getParentState((EditPart)host);
        if (containerEditPart == null && (containerEditPart = this.getParentRegion((EditPart)host)) == null) {
            return null;
        }
        return containerEditPart;
    }

    protected void setBounds(IFigure figure, Rectangle bounds) {
        figure.setBounds(bounds);
        figure.getParent().setConstraint(figure, (Object)bounds);
    }

    private PrecisionRectangle calculateFeedbackBounds(ChangeBoundsRequest request, Rectangle feedbackBounds, IFigure containerFigure) {
        PrecisionRectangle result = new PrecisionRectangle(feedbackBounds.getCopy());
        List editParts = request.getEditParts();
        for (IGraphicalEditPart editPart : editParts) {
            PrecisionRectangle transformedRect = new PrecisionRectangle(editPart.getFigure().getBounds().getCopy());
            editPart.getFigure().translateToAbsolute((Translatable)transformedRect);
            result.union((Rectangle)transformedRect);
        }
        PrecisionDimension preferredSize = new PrecisionDimension(containerFigure.getPreferredSize().getCopy());
        containerFigure.translateToAbsolute((Translatable)preferredSize);
        if (result.preciseWidth() < preferredSize.preciseWidth() + 20.0) {
            result.setPreciseWidth(preferredSize.preciseWidth() + 20.0);
        }
        if (result.preciseHeight() < preferredSize.preciseHeight() + 20.0) {
            result.setPreciseHeight(preferredSize.preciseHeight() + 20.0);
        }
        if (result.x < feedbackBounds.x) {
            result.x = feedbackBounds.x;
        }
        if (result.y < feedbackBounds.y) {
            result.y = feedbackBounds.y;
        }
        return result;
    }

    protected IGraphicalEditPart getParentRegion(EditPart part) {
        part = part.getParent();
        while (!(part instanceof RegionEditPart)) {
            if ((part = part.getParent()) != null) continue;
            return null;
        }
        return (IGraphicalEditPart)part;
    }

    protected IGraphicalEditPart getParentState(EditPart part) {
        part = part.getParent();
        while (!(part instanceof StateEditPart)) {
            if ((part = part.getParent()) != null) continue;
            return null;
        }
        return (IGraphicalEditPart)part;
    }
}

