/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.providers;

import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.ClipboardManager;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.common.ui.util.CustomDataTransfer;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.CopyCommand;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.dnd.Transfer;

public class SubdiagramAwareCopyCommand
extends CopyCommand
implements ICommand {
    public SubdiagramAwareCopyCommand(TransactionalEditingDomain editingDomain, String label, View viewContext, List source) {
        super(editingDomain, label, viewContext, source);
    }

    protected void copyToClipboard(List source) {
        if (source == null || source.size() == 0) {
            return;
        }
        CustomData data = this.copyViews(source);
        this.addToClipboardManager(data);
    }

    protected void addToClipboardManager(CustomData data) {
        if (data != null) {
            ClipboardManager.getInstance().addToCache((Object)new ICustomData[]{data}, (Transfer)CustomDataTransfer.getInstance());
        }
    }

    protected CustomData copyViews(List source) {
        String copy = this.copyWithSubdiagrams(source);
        return new CustomData("Drawing Surface", copy.getBytes());
    }

    protected String copyWithSubdiagrams(List views) {
        Assert.isNotNull((Object)views);
        Assert.isTrue((views.size() > 0 ? 1 : 0) != 0);
        ArrayList<Object> selection = new ArrayList<Object>();
        for (View viewElement : views) {
            if (viewElement == null) continue;
            selection.add(viewElement);
        }
        selection.addAll(this.getInnerEdges(views));
        selection.add(this.getMeasurementUnitAnnotation(views));
        List<Diagram> subDiagrams = this.getSubDiagrams(views);
        selection.addAll(subDiagrams);
        for (Diagram diagram : subDiagrams) {
            selection.addAll(this.getInnerEdges((List)diagram.getChildren()));
        }
        return ClipboardUtil.copyElementsToString(selection, new HashMap(), (IProgressMonitor)new NullProgressMonitor());
    }

    protected EAnnotation getMeasurementUnitAnnotation(List views) {
        View firstView = (View)views.get(0);
        Diagram dgrm = firstView.getDiagram();
        EAnnotation measureUnitAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        measureUnitAnnotation.setSource(dgrm.getMeasurementUnit().getName());
        return measureUnitAnnotation;
    }

    protected List<Edge> getInnerEdges(List views) {
        LinkedList<Edge> innerEdges = new LinkedList<Edge>();
        for (View view : views) {
            if (view instanceof Diagram) continue;
            innerEdges.addAll(ViewUtil.getAllInnerEdges((View)view));
        }
        return innerEdges;
    }

    protected List<Diagram> getSubDiagrams(List views) {
        ArrayList<Diagram> subDiagrams = new ArrayList<Diagram>();
        for (View viewElement : views) {
            if (viewElement == null) continue;
            EObject semanticElement = viewElement.getElement();
            if (semanticElement instanceof State) {
                this.collectSubdiagramsInState(subDiagrams, (State)semanticElement);
                continue;
            }
            if (!(semanticElement instanceof Region)) continue;
            this.collectSubdiagramsInRegion(subDiagrams, (Region)semanticElement);
        }
        return subDiagrams;
    }

    protected void collectSubdiagramsInRegion(List<Diagram> subDiagrams, Region region) {
        for (Vertex vertex : region.getVertices()) {
            if (!(vertex instanceof State)) continue;
            this.collectSubdiagramsInState(subDiagrams, (State)vertex);
        }
    }

    protected void collectSubdiagramsInState(List<Diagram> subDiagrams, State state) {
        if (state.isComposite()) {
            subDiagrams.addAll(this.getAllSubDiagrams(state));
        }
    }

    protected Collection<? extends Diagram> getAllSubDiagrams(State semanticState) {
        ArrayList<Diagram> subDiagrams = new ArrayList<Diagram>();
        this.addSubDiagram(semanticState, subDiagrams);
        TreeIterator iter = semanticState.eAllContents();
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (!(next instanceof State)) continue;
            State subState = (State)next;
            if (subState.isComposite()) {
                this.addSubDiagram(subState, subDiagrams);
                continue;
            }
            iter.prune();
        }
        return subDiagrams;
    }

    protected void addSubDiagram(State semanticState, List<Diagram> subDiagrams) {
        Diagram subDiagram = DiagramPartitioningUtil.getSubDiagram((CompositeElement)semanticState);
        if (subDiagram != null) {
            subDiagrams.add(subDiagram);
        }
    }
}

